"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecoveryIndex = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _snapshot = require("./snapshot");
var _i18nReact = require("@kbn/i18n-react");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecoveryIndex = props => {
  const {
    name,
    shard,
    relocationType
  } = props;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/indices/${name}`)
  }, name), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardActivity.recoveryIndex.shardDescription",
    defaultMessage: "Shard: {shard}",
    values: {
      shard
    }
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardActivity.recoveryIndex.recoveryTypeDescription",
    defaultMessage: "Recovery type: {relocationType}",
    values: {
      relocationType
    }
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_snapshot.Snapshot, props)));
};
exports.RecoveryIndex = RecoveryIndex;