"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetailStatus = NodeDetailStatus;
var _react = _interopRequireWildcard(require("react"));
var _summary_status = require("../../summary_status");
var _node = require("../node");
var _format_number = require("../../../lib/format_number");
var _i18n = require("@kbn/i18n");
var _status = require("../../../alerts/status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NodeDetailStatus({
  stats,
  alerts = {}
}) {
  const {
    transport_address: transportAddress,
    usedHeap,
    freeSpace,
    totalSpace,
    documents,
    dataSize,
    indexCount,
    totalShards,
    nodeTypeLabel,
    status,
    isOnline
  } = stats;
  const percentSpaceUsed = freeSpace / totalSpace * 100;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.alerts', {
      defaultMessage: 'Alerts'
    }),
    value: /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      alerts: alerts,
      showOnlyCount: true
    })
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.transportAddress', {
      defaultMessage: 'Transport Address'
    }),
    value: transportAddress,
    'data-test-subj': 'transportAddress'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.jvmHeapLabel', {
      defaultMessage: '{javaVirtualMachine} Heap',
      values: {
        javaVirtualMachine: 'JVM'
      }
    }),
    value: (0, _format_number.formatMetric)(usedHeap, '0,0.[00]', '%', {
      prependSpace: false
    }),
    'data-test-subj': 'jvmHeap'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.freeDiskSpaceLabel', {
      defaultMessage: 'Free Disk Space'
    }),
    value: (0, _format_number.formatMetric)(freeSpace, '0.0 b') + ' (' + (0, _format_number.formatMetric)(percentSpaceUsed, '0,0.[00]', '%', {
      prependSpace: false
    }) + ')',
    'data-test-subj': 'freeDiskSpace'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.documentsLabel', {
      defaultMessage: 'Documents'
    }),
    value: (0, _format_number.formatMetric)(documents, '0.[0]a'),
    'data-test-subj': 'documentCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.dataLabel', {
      defaultMessage: 'Data'
    }),
    value: (0, _format_number.formatMetric)(dataSize, '0.0 b'),
    'data-test-subj': 'dataSize'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.indicesLabel', {
      defaultMessage: 'Indices'
    }),
    value: (0, _format_number.formatMetric)(indexCount, 'int_commas'),
    'data-test-subj': 'indicesCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.shardsLabel', {
      defaultMessage: 'Shards'
    }),
    value: (0, _format_number.formatMetric)(totalShards, 'int_commas'),
    'data-test-subj': 'shardsCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodeDetailStatus.typeLabel', {
      defaultMessage: 'Type'
    }),
    value: nodeTypeLabel,
    'data-test-subj': 'nodeType'
  }];
  const IconComponent = ({
    status,
    isOnline
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_node.NodeStatusIcon, {
    status: status,
    isOnline: isOnline
  }));
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    status: status,
    isOnline: isOnline,
    IconComponent: IconComponent,
    "data-test-subj": "elasticsearchNodeDetailStatus"
  });
}