"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStashNodeAdvancedPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _global_state_context = require("../../contexts/global_state_context");
var _logstash_template = require("./logstash_template");
var _detail_status = require("../../../components/logstash/detail_status");
var _chart = require("../../../components/chart");
var _callout = require("../../../alerts/callout");
var _use_charts = require("../../hooks/use_charts");
var _fetch_alerts = require("../../../lib/fetch_alerts");
var _constants = require("../../../../common/constants");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogStashNodeAdvancedPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const match = (0, _reactRouterDom.useRouteMatch)();
  const {
    services
  } = (0, _public.useKibana)();
  const clusterUuid = globalState.cluster_uuid;
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const [data, setData] = (0, _react.useState)({});
  const [alerts, setAlerts] = (0, _react.useState)({});
  const title = _i18n.i18n.translate('xpack.monitoring.logstash.node.advanced.routeTitle', {
    defaultMessage: 'Logstash - {nodeName} - Advanced',
    values: {
      nodeName: data.nodeSummary ? data.nodeSummary.name : ''
    }
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.logstash.node.advanced.pageTitle', {
    defaultMessage: 'Logstash node: {nodeName}',
    values: {
      nodeName: data.nodeSummary ? data.nodeSummary.name : ''
    }
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/logstash/node/${match.params.uuid}`;
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch && clusterUuid) {
      var _services$http2;
      const response = await ((_services$http2 = services.http) === null || _services$http2 === void 0 ? void 0 : _services$http2.fetch(url, {
        method: 'POST',
        body: JSON.stringify({
          ccs,
          timeRange: {
            min: bounds.min.toISOString(),
            max: bounds.max.toISOString()
          },
          is_advanced: true
        })
      }));
      setData(response);
      const alertsResponse = await (0, _fetch_alerts.fetchAlerts)({
        fetch: services.http.fetch,
        alertTypeIds: [_constants.RULE_LOGSTASH_VERSION_MISMATCH],
        clusterUuid,
        timeRange: {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        }
      });
      setAlerts(alertsResponse);
    }
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http, match.params.uuid]);
  const metricsToShow = (0, _react.useMemo)(() => {
    if (!data.metrics) return [];
    return [data.metrics.logstash_node_cpu_utilization, data.metrics.logstash_queue_events_count, data.metrics.logstash_node_cgroup_cpu, data.metrics.logstash_pipeline_queue_size, data.metrics.logstash_node_cgroup_stats];
  }, [data.metrics]);
  (0, _react.useEffect)(() => {
    if (cluster && data.nodeSummary) {
      generateBreadcrumbs(cluster.cluster_name, {
        inLogstash: true,
        instance: data.nodeSummary.host,
        name: 'nodes'
      });
    }
  }, [cluster, data, generateBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_logstash_template.LogstashTemplate, {
    instance: data,
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    cluster: cluster
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, data.nodeSummary && /*#__PURE__*/_react.default.createElement(_detail_status.DetailStatus, {
    stats: data.nodeSummary
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_callout.AlertsCallout, {
    alerts: alerts
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, metricsToShow.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric,
    onBrush: onBrush,
    zoomInfo: zoomInfo
  }, data)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))))))));
};
exports.LogStashNodeAdvancedPage = LogStashNodeAdvancedPage;