"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchNodesPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _elasticsearch_template = require("./elasticsearch_template");
var _global_state_context = require("../../contexts/global_state_context");
var _external_config_context = require("../../contexts/external_config_context");
var _elasticsearch = require("../../../components/elasticsearch");
var _setup_mode = require("../../../components/renderers/setup_mode");
var _setup_mode_context = require("../../../components/setup_mode/setup_mode_context");
var _use_table = require("../../hooks/use_table");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _fetch_alerts = require("../../../lib/fetch_alerts");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rolesByImportance = ['master', 'voting_only', 'data', 'data_content', 'data_hot', 'data_warm', 'data_cold', 'data_frozen', 'ingest', 'transform', 'ml', 'remote_cluster_client'];
const ElasticsearchNodesPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    showCgroupMetricsElasticsearch
  } = (0, _react.useContext)(_external_config_context.ExternalConfigContext);
  const {
    services
  } = (0, _public.useKibana)();
  const [isLoading, setIsLoading] = _react.default.useState(false);
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const {
    getPaginationRouteOptions,
    updateTotalItemCount,
    getPaginationTableProps
  } = (0, _use_table.useTable)('elasticsearch.nodes');
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)({});
  const [alerts, setAlerts] = (0, _react.useState)({});
  const title = _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodes.routeTitle', {
    defaultMessage: 'Elasticsearch - Nodes'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.elasticsearch.nodes.pageTitle', {
    defaultMessage: 'Elasticsearch nodes'
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inElasticsearch: true
      });
    }
  }, [cluster, generateBreadcrumbs]);
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/elasticsearch/nodes`;
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch && clusterUuid) {
      var _services$http2;
      setIsLoading(true);
      const response = await ((_services$http2 = services.http) === null || _services$http2 === void 0 ? void 0 : _services$http2.fetch(url, {
        method: 'POST',
        body: JSON.stringify({
          ccs,
          timeRange: {
            min: bounds.min.toISOString(),
            max: bounds.max.toISOString()
          },
          ...getPaginationRouteOptions()
        })
      }));
      setIsLoading(false);
      const {
        nodes
      } = response;
      const nodesWithSortedRoles = nodes.map(node => {
        const sortedRoles = sortNodeRoles(node.roles);
        return {
          ...node,
          roles: sortedRoles
        };
      });
      setData({
        ...response,
        nodes: nodesWithSortedRoles
      });
      updateTotalItemCount(response.totalNodeCount);
      const alertsResponse = await (0, _fetch_alerts.fetchAlerts)({
        fetch: services.http.fetch,
        clusterUuid,
        alertTypeIds: [_constants.RULE_CPU_USAGE, _constants.RULE_DISK_USAGE, _constants.RULE_THREAD_POOL_SEARCH_REJECTIONS, _constants.RULE_THREAD_POOL_WRITE_REJECTIONS, _constants.RULE_MEMORY_USAGE, _constants.RULE_MISSING_MONITORING_DATA],
        timeRange: {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        }
      });
      setAlerts(alertsResponse);
    }
  }, [(_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http, clusterUuid, ccs, getPaginationRouteOptions, updateTotalItemCount]);
  return /*#__PURE__*/_react.default.createElement(_elasticsearch_template.ElasticsearchTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    "data-test-subj": "elasticsearchOverviewPage",
    cluster: cluster
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "elasticsearchNodesListingPage"
  }, /*#__PURE__*/_react.default.createElement(_setup_mode.SetupModeRenderer, {
    productName: _constants.ELASTICSEARCH_SYSTEM_ID,
    render: ({
      setupMode,
      flyoutComponent,
      bottomBarComponent
    }) => /*#__PURE__*/_react.default.createElement(_setup_mode_context.SetupModeContext.Provider, {
      value: {
        setupModeSupported: true
      }
    }, flyoutComponent, /*#__PURE__*/_react.default.createElement(_elasticsearch.ElasticsearchNodes, (0, _extends2.default)({
      clusterStatus: data.clusterStatus,
      clusterUuid: globalState.cluster_uuid,
      setupMode: setupMode,
      nodes: data.nodes,
      alerts: alerts,
      isLoading: isLoading,
      showCgroupMetricsElasticsearch: showCgroupMetricsElasticsearch
    }, getPaginationTableProps())), bottomBarComponent)
  })));
};
exports.ElasticsearchNodesPage = ElasticsearchNodesPage;
function sortNodeRoles(roles) {
  if (!roles) {
    return undefined;
  }
  const rolesList = Array.isArray(roles) ? roles : [roles];
  if (rolesList.length === 0) {
    return [];
  }
  const rolesAsSet = new Set(rolesList);
  return rolesByImportance.filter(role => rolesAsSet.has(role));
}