"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatMonitoringError = formatMonitoringError;
exports.useRequestErrorHandler = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _format_msg = require("../../lib/format_msg");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatMonitoringError(err) {
  var _err$response, _err$response2;
  if ((_err$response = err.response) !== null && _err$response !== void 0 && _err$response.status && ((_err$response2 = err.response) === null || _err$response2 === void 0 ? void 0 : _err$response2.status) !== -1) {
    var _err$body, _err$response3;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.ajaxErrorHandler.httpErrorMessage",
      defaultMessage: "HTTP {errStatus}",
      values: {
        errStatus: (_err$response3 = err.response) === null || _err$response3 === void 0 ? void 0 : _err$response3.status
      }
    })));
  }
  return (0, _format_msg.formatMsg)(err);
}
const useRequestErrorHandler = () => {
  var _services$notificatio3;
  const {
    services
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(err => {
    var _err$response4, _err$response5;
    if (((_err$response4 = err.response) === null || _err$response4 === void 0 ? void 0 : _err$response4.status) === 403) {
      // redirect to error message view
      history.push('/access-denied');
    } else if (((_err$response5 = err.response) === null || _err$response5 === void 0 ? void 0 : _err$response5.status) === 404 && !(0, _lodash.includes)(window.location.hash, 'no-data')) {
      var _services$notificatio, _services$theme;
      // pass through if this is a 404, and we're already on the no-data page
      const formattedError = formatMonitoringError(err);
      (_services$notificatio = services.notifications) === null || _services$notificatio === void 0 ? void 0 : _services$notificatio.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.ajaxErrorHandler.requestFailedNotificationTitle', {
          defaultMessage: 'Monitoring Request Failed'
        }),
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement("div", null, formattedError, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          color: "danger",
          onClick: () => window.location.reload()
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.ajaxErrorHandler.requestFailedNotification.retryButtonLabel",
          defaultMessage: "Retry"
        }))), {
          theme$: (_services$theme = services.theme) === null || _services$theme === void 0 ? void 0 : _services$theme.theme$
        })
      });
    } else {
      var _services$notificatio2, _services$theme2;
      (_services$notificatio2 = services.notifications) === null || _services$notificatio2 === void 0 ? void 0 : _services$notificatio2.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.monitoring.ajaxErrorHandler.requestErrorNotificationTitle', {
          defaultMessage: 'Monitoring Request Error'
        }),
        text: (0, _public.toMountPoint)(formatMonitoringError(err), {
          theme$: (_services$theme2 = services.theme) === null || _services$theme2 === void 0 ? void 0 : _services$theme2.theme$
        })
      });
    }
  }, [history, (_services$notificatio3 = services.notifications) === null || _services$notificatio3 === void 0 ? void 0 : _services$notificatio3.toasts, services.theme]);
};
exports.useRequestErrorHandler = useRequestErrorHandler;