"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitoringTimeContainerContext = exports.useMonitoringTime = exports.MonitoringTimeContainer = exports.DEFAULT_TIMERANGE = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _public = require("@kbn/kibana-react-plugin/public");
var _legacy_shims = require("../../legacy_shims");
var _global_state_context = require("../contexts/global_state_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIMERANGE = {
  from: 'now-1h',
  to: 'now',
  interval: '>=10s'
};
exports.DEFAULT_TIMERANGE = DEFAULT_TIMERANGE;
const useMonitoringTime = () => {
  var _services$data, _services$data2;
  const {
    services
  } = (0, _public.useKibana)();
  const state = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const defaultTimeRange = {
    ...DEFAULT_TIMERANGE,
    ...((_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getTime())
  };
  const {
    value,
    pause
  } = (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter.getRefreshInterval();
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(value);
  const [isPaused, setIsPaused] = (0, _react.useState)(pause);
  const [currentTimerange, setTimeRange] = (0, _react.useState)(defaultTimeRange);
  const [isDisabled, setIsDisabled] = (0, _react.useState)(false);
  const handleTimeChange = (0, _react.useCallback)((start, end) => {
    var _state$save;
    setTimeRange({
      ...currentTimerange,
      from: start,
      to: end
    });
    state.time = {
      from: start,
      to: end
    };
    _legacy_shims.Legacy.shims.timefilter.setTime(state.time);
    (_state$save = state.save) === null || _state$save === void 0 ? void 0 : _state$save.call(state);
  }, [currentTimerange, setTimeRange, state]);
  (0, _react.useEffect)(() => {
    const sub = _legacy_shims.Legacy.shims.timefilter.getTimeUpdate$().subscribe(function onTimeUpdate() {
      var _state$save2;
      const updatedTime = _legacy_shims.Legacy.shims.timefilter.getTime();
      setTimeRange({
        ...currentTimerange,
        ...updatedTime
      });
      state.time = {
        ...updatedTime
      };
      (_state$save2 = state.save) === null || _state$save2 === void 0 ? void 0 : _state$save2.call(state);
    });
    return () => sub.unsubscribe();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    currentTimerange,
    setTimeRange,
    handleTimeChange,
    setRefreshInterval,
    refreshInterval,
    setIsPaused,
    isPaused,
    setIsDisabled,
    isDisabled
  };
};
exports.useMonitoringTime = useMonitoringTime;
const [MonitoringTimeContainer, useMonitoringTimeContainerContext] = (0, _constate.default)(useMonitoringTime);
exports.useMonitoringTimeContainerContext = useMonitoringTimeContainerContext;
exports.MonitoringTimeContainer = MonitoringTimeContainer;