"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsDropdown = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_alerts_modal = require("../application/hooks/use_alerts_modal");
var _enable_alerts_modal = require("./enable_alerts_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsDropdown = () => {
  const [shouldShowModal, setShouldShowModal] = (0, _react.useState)(false);
  const alertsEnableModalProvider = (0, _use_alerts_modal.useAlertsModal)();
  const {
    navigateToApp
  } = (0, _public.useKibana)().services.application;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const togglePopoverVisibility = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const createDefaultRules = () => {
    setShouldShowModal(true);
  };
  const createButtonClick = () => {
    alertsEnableModalProvider.enableAlerts();
    closeModal();
  };
  const closeModal = () => {
    setShouldShowModal(false);
    closePopover();
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: 'right',
    iconType: 'arrowDown',
    onClick: togglePopoverVisibility
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.dropdown.button",
    defaultMessage: "Alerts and rules"
  }));
  const items = [{
    name: _i18n.i18n.translate('xpack.monitoring.alerts.dropdown.createAlerts', {
      defaultMessage: 'Create default rules'
    }),
    onClick: createDefaultRules
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.alerts.dropdown.manageRules', {
      defaultMessage: 'Manage rules'
    }),
    icon: 'tableOfContents',
    onClick: () => navigateToApp('management', {
      path: '/insightsAndAlerting/triggersActions/rules'
    })
  }];
  const panels = [{
    id: 0,
    title: _i18n.i18n.translate('xpack.monitoring.alerts.dropdown.title', {
      defaultMessage: 'Alerts and rules'
    }),
    items
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  })), shouldShowModal ? /*#__PURE__*/_react.default.createElement(_enable_alerts_modal.WatcherMigrationStep, {
    closeModal: closeModal,
    createButtonClick: createButtonClick
  }) : null);
};
exports.AlertsDropdown = AlertsDropdown;