"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PainlessWorker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PainlessWorker {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "_ctx", void 0);
    this._ctx = ctx;
  }
  getTextDocument(modelUri) {
    const model = this._ctx.getMirrorModels().find(m => m.uri.toString() === modelUri);
    return model === null || model === void 0 ? void 0 : model.getValue();
  }
  async getSyntaxErrors(modelUri) {
    const code = this.getTextDocument(modelUri);
    if (code) {
      return (0, _lib.parseAndGetSyntaxErrors)(code);
    }
  }
  provideAutocompleteSuggestions(currentLineChars, context, fields) {
    // Array of the active line words, e.g., [boolean, isTrue, =, true]
    const words = currentLineChars.replace('\t', '').split(' ');
    const autocompleteSuggestions = (0, _lib.getAutocompleteSuggestions)(context, words, fields);
    return autocompleteSuggestions;
  }
}
exports.PainlessWorker = PainlessWorker;