"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringHash = stringHash;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a deterministic number based hash out of a string.
 */
function stringHash(str) {
  let hash = 0;
  let chr = 0;
  if (str.length === 0) {
    return hash;
  }
  for (let i = 0; i < str.length; i++) {
    chr = str.charCodeAt(i);
    hash = (hash << 5) - hash + chr; // eslint-disable-line no-bitwise
    hash |= 0; // eslint-disable-line no-bitwise
  }

  return hash < 0 ? hash * -2 : hash;
}