"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopsDataFrameAnalyticsJobQuerySchema = exports.deleteDataFrameAnalyticsJobSchema = exports.dataFrameAnalyticsQuerySchema = exports.dataFrameAnalyticsNewJobCapsQuerySchema = exports.dataFrameAnalyticsNewJobCapsParamsSchema = exports.dataFrameAnalyticsMapQuerySchema = exports.dataFrameAnalyticsJobsExistSchema = exports.dataFrameAnalyticsJobUpdateSchema = exports.dataFrameAnalyticsJobConfigSchema = exports.dataFrameAnalyticsIdSchema = exports.dataFrameAnalyticsExplainSchema = exports.dataFrameAnalyticsEvaluateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _runtime_mappings_schema = require("./runtime_mappings_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataFrameAnalyticsJobConfigSchema = _configSchema.schema.object({
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  _meta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  dest: _configSchema.schema.object({
    index: _configSchema.schema.string(),
    results_field: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  source: _configSchema.schema.object({
    index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]),
    query: _configSchema.schema.maybe(_configSchema.schema.any()),
    runtime_mappings: _runtime_mappings_schema.runtimeMappingsSchema,
    _source: _configSchema.schema.maybe(_configSchema.schema.object({
      /** Fields to include in results */
      includes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.maybe(_configSchema.schema.string()))),
      /** Fields to exclude from results */
      excludes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.maybe(_configSchema.schema.string())))
    }))
  }),
  allow_lazy_start: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  analysis: _configSchema.schema.any(),
  analyzed_fields: _configSchema.schema.any(),
  model_memory_limit: _configSchema.schema.string(),
  max_num_threads: _configSchema.schema.maybe(_configSchema.schema.number())
});
exports.dataFrameAnalyticsJobConfigSchema = dataFrameAnalyticsJobConfigSchema;
const dataFrameAnalyticsEvaluateSchema = _configSchema.schema.object({
  index: _configSchema.schema.string(),
  query: _configSchema.schema.maybe(_configSchema.schema.any()),
  evaluation: _configSchema.schema.maybe(_configSchema.schema.object({
    regression: _configSchema.schema.maybe(_configSchema.schema.any()),
    classification: _configSchema.schema.maybe(_configSchema.schema.any()),
    outlier_detection: _configSchema.schema.maybe(_configSchema.schema.any())
  }))
});
exports.dataFrameAnalyticsEvaluateSchema = dataFrameAnalyticsEvaluateSchema;
const dataFrameAnalyticsExplainSchema = _configSchema.schema.object({
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  dest: _configSchema.schema.maybe(_configSchema.schema.any()),
  /** Source */
  source: _configSchema.schema.object({
    index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]),
    query: _configSchema.schema.maybe(_configSchema.schema.any()),
    runtime_mappings: _runtime_mappings_schema.runtimeMappingsSchema
  }),
  analysis: _configSchema.schema.any(),
  analyzed_fields: _configSchema.schema.maybe(_configSchema.schema.any()),
  model_memory_limit: _configSchema.schema.maybe(_configSchema.schema.string()),
  max_num_threads: _configSchema.schema.maybe(_configSchema.schema.number()),
  _meta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
exports.dataFrameAnalyticsExplainSchema = dataFrameAnalyticsExplainSchema;
const dataFrameAnalyticsIdSchema = _configSchema.schema.object({
  /**
   * Analytics ID
   */
  analyticsId: _configSchema.schema.string()
});
exports.dataFrameAnalyticsIdSchema = dataFrameAnalyticsIdSchema;
const dataFrameAnalyticsQuerySchema = _configSchema.schema.object({
  /**
   * Analytics Query
   */
  excludeGenerated: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  size: _configSchema.schema.maybe(_configSchema.schema.number())
});
exports.dataFrameAnalyticsQuerySchema = dataFrameAnalyticsQuerySchema;
const deleteDataFrameAnalyticsJobSchema = _configSchema.schema.object({
  /**
   * Analytics Destination Index
   */
  deleteDestIndex: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  deleteDestDataView: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  force: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
exports.deleteDataFrameAnalyticsJobSchema = deleteDataFrameAnalyticsJobSchema;
const dataFrameAnalyticsJobUpdateSchema = _configSchema.schema.object({
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  model_memory_limit: _configSchema.schema.maybe(_configSchema.schema.string()),
  allow_lazy_start: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  max_num_threads: _configSchema.schema.maybe(_configSchema.schema.number()),
  _meta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
exports.dataFrameAnalyticsJobUpdateSchema = dataFrameAnalyticsJobUpdateSchema;
const stopsDataFrameAnalyticsJobQuerySchema = _configSchema.schema.object({
  force: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
exports.stopsDataFrameAnalyticsJobQuerySchema = stopsDataFrameAnalyticsJobQuerySchema;
const dataFrameAnalyticsJobsExistSchema = _configSchema.schema.object({
  analyticsIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  allSpaces: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
exports.dataFrameAnalyticsJobsExistSchema = dataFrameAnalyticsJobsExistSchema;
const dataFrameAnalyticsMapQuerySchema = _configSchema.schema.maybe(_configSchema.schema.object({
  treatAsRoot: _configSchema.schema.maybe(_configSchema.schema.any()),
  type: _configSchema.schema.maybe(_configSchema.schema.string())
}));
exports.dataFrameAnalyticsMapQuerySchema = dataFrameAnalyticsMapQuerySchema;
const dataFrameAnalyticsNewJobCapsParamsSchema = _configSchema.schema.object({
  indexPattern: _configSchema.schema.string()
});
exports.dataFrameAnalyticsNewJobCapsParamsSchema = dataFrameAnalyticsNewJobCapsParamsSchema;
const dataFrameAnalyticsNewJobCapsQuerySchema = _configSchema.schema.maybe(_configSchema.schema.object({
  rollup: _configSchema.schema.maybe(_configSchema.schema.string())
}));
exports.dataFrameAnalyticsNewJobCapsQuerySchema = dataFrameAnalyticsNewJobCapsQuerySchema;