"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCategorizationADJobAction = createCategorizationADJobAction;
exports.createCategorizationADJobTrigger = void 0;
var _i18n = require("@kbn/i18n");
var _mlUiActions = require("@kbn/ml-ui-actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const createCategorizationADJobTrigger = {
  id: _mlUiActions.CREATE_PATTERN_ANALYSIS_TO_ML_AD_JOB_TRIGGER,
  title: _i18n.i18n.translate('xpack.ml.actions.createADJobFromPatternAnalysis', {
    defaultMessage: 'Create categorization anomaly detection job'
  }),
  description: _i18n.i18n.translate('xpack.ml.actions.createADJobFromPatternAnalysis', {
    defaultMessage: 'Create categorization anomaly detection job'
  })
};
exports.createCategorizationADJobTrigger = createCategorizationADJobTrigger;
function createCategorizationADJobAction(getStartServices) {
  return {
    id: 'create-ml-categorization-ad-job-action',
    type: _mlUiActions.CREATE_PATTERN_ANALYSIS_TO_ML_AD_JOB_ACTION,
    getIconType(context) {
      return 'machineLearningApp';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.createADJobFromPatternAnalysis', {
      defaultMessage: 'Create categorization anomaly detection job'
    }),
    async execute({
      dataView,
      field,
      query,
      timeRange
    }) {
      if (!dataView) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      try {
        const [{
          showPatternAnalysisToADJobFlyout
        }, [coreStart, {
          share,
          data,
          dashboard
        }]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/job_creation/aiops'))), getStartServices()]);
        await showPatternAnalysisToADJobFlyout(dataView, field, query, timeRange, coreStart, share, data, dashboard);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      dataView,
      field
    }) {
      return dataView.timeFieldName !== undefined && dataView.fields.find(f => f.name === field.name) !== undefined;
    }
  };
}