"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAnomalyExplorerEmbeddable = isAnomalyExplorerEmbeddable;
exports.isSwimLaneEmbeddable = isSwimLaneEmbeddable;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isSwimLaneEmbeddable(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['embeddable']) && (0, _mlIsPopulatedObject.isPopulatedObject)(arg.embeddable, ['type']) && arg.embeddable.type === _constants.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE;
}

/**
 * Anomaly Explorer
 */

function isAnomalyExplorerEmbeddable(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['embeddable']) && (0, _mlIsPopulatedObject.isPopulatedObject)(arg.embeddable, ['type']) && arg.embeddable.type === _constants.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE;
}