"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processFilters = processFilters;
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processFilters(optionalFilters, optionalQuery, controlledBy) {
  const filters = optionalFilters !== null && optionalFilters !== void 0 ? optionalFilters : [];
  const query = optionalQuery !== null && optionalQuery !== void 0 ? optionalQuery : (0, _public.getDefaultQuery)();
  const inputQuery = query.language === 'kuery' ? (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query.query)) : (0, _esQuery.luceneStringToDsl)(query.query);
  const must = [inputQuery];
  const mustNot = [];
  for (const filter of filters) {
    // ignore disabled filters as well as created by swim lane selection
    if (filter.meta.disabled || controlledBy !== undefined && filter.meta.controlledBy === controlledBy) continue;
    const {
      meta: {
        negate,
        type,
        key: fieldName
      }
    } = filter;
    let filterQuery = filter.query;
    if (filterQuery === undefined && type === 'exists') {
      filterQuery = {
        exists: {
          field: fieldName
        }
      };
    }
    if (filterQuery) {
      if (negate) {
        mustNot.push(filterQuery);
      } else {
        must.push(filterQuery);
      }
    }
  }
  return {
    bool: {
      must,
      must_not: mustNot
    }
  };
}