"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultSwimlanePanelTitle = exports.AnomalySwimlaneEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _embeddable_swim_lane_container_lazy = require("./embeddable_swim_lane_container_lazy");
var _ui_actions = require("../../ui_actions");
var _ = require("..");
var _embeddable_loading_fallback = require("../common/components/embeddable_loading_fallback");
var _anomaly_detection_embeddable = require("../common/anomaly_detection_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultSwimlanePanelTitle = jobIds => _i18n.i18n.translate('xpack.ml.swimlaneEmbeddable.title', {
  defaultMessage: 'ML anomaly swim lane for {jobIds}',
  values: {
    jobIds: jobIds.join(', ')
  }
});
exports.getDefaultSwimlanePanelTitle = getDefaultSwimlanePanelTitle;
class AnomalySwimlaneEmbeddable extends _anomaly_detection_embeddable.AnomalyDetectionEmbeddable {
  constructor(initialInput, services, parent) {
    super(initialInput, services[2].anomalyDetectorService, services[1].data.dataViews, parent);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "type", _.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE);
    this.services = services;
  }
  reportsEmbeddableLoad() {
    return true;
  }
  onLoading() {
    this.renderComplete.dispatchInProgress();
    this.updateOutput({
      loading: true,
      error: undefined
    });
  }
  onError(error) {
    this.renderComplete.dispatchError();
    this.updateOutput({
      loading: false,
      error: {
        name: error.name,
        message: error.message
      }
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
    this.updateOutput({
      loading: false,
      error: undefined
    });
  }
  render(node) {
    super.render(node);
    this.node = node;

    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const I18nContext = this.services[0].i18n.Context;
    const theme$ = this.services[0].theme.theme$;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...this.services[0]
      }
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_embeddable_loading_fallback.EmbeddableLoading, null)
    }, /*#__PURE__*/_react.default.createElement(_embeddable_swim_lane_container_lazy.EmbeddableSwimLaneContainer, {
      id: this.input.id,
      embeddableContext: this,
      embeddableInput$: this.getInput$(),
      services: this.services,
      refresh: this.reload$.asObservable(),
      onInputChange: this.updateInput.bind(this),
      onOutputChange: this.updateOutput.bind(this),
      onRenderComplete: this.onRenderComplete.bind(this),
      onLoading: this.onLoading.bind(this),
      onError: this.onError.bind(this)
    }))))), node);
  }
  destroy() {
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  reload() {
    this.reload$.next();
  }
  supportedTriggers() {
    return [_ui_actions.SWIM_LANE_SELECTION_TRIGGER];
  }
}
exports.AnomalySwimlaneEmbeddable = AnomalySwimlaneEmbeddable;