"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getControlsForDetector = getControlsForDetector;
var _job_service = require("../services/job_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extracts entities from the detector configuration
 */
function getControlsForDetector(selectedDetectorIndex, selectedEntities, selectedJobId) {
  const selectedJob = _job_service.mlJobService.getJob(selectedJobId);
  const entities = [];
  if (selectedJob === undefined) {
    return entities;
  }

  // Update the entity dropdown control(s) according to the partitioning fields for the selected detector.
  const detectorIndex = selectedDetectorIndex;
  const detector = selectedJob.analysis_config.detectors[detectorIndex];
  const entitiesState = selectedEntities;
  const partitionFieldName = detector === null || detector === void 0 ? void 0 : detector.partition_field_name;
  const overFieldName = detector === null || detector === void 0 ? void 0 : detector.over_field_name;
  const byFieldName = detector === null || detector === void 0 ? void 0 : detector.by_field_name;
  if (partitionFieldName !== undefined) {
    var _entitiesState$partit;
    const partitionFieldValue = (_entitiesState$partit = entitiesState === null || entitiesState === void 0 ? void 0 : entitiesState[partitionFieldName]) !== null && _entitiesState$partit !== void 0 ? _entitiesState$partit : null;
    entities.push({
      fieldType: 'partition_field',
      fieldName: partitionFieldName,
      fieldValue: partitionFieldValue
    });
  }
  if (overFieldName !== undefined) {
    var _entitiesState$overFi;
    const overFieldValue = (_entitiesState$overFi = entitiesState === null || entitiesState === void 0 ? void 0 : entitiesState[overFieldName]) !== null && _entitiesState$overFi !== void 0 ? _entitiesState$overFi : null;
    entities.push({
      fieldType: 'over_field',
      fieldName: overFieldName,
      fieldValue: overFieldValue
    });
  }

  // For jobs with by and over fields, don't add the 'by' field as this
  // field will only be added to the top-level fields for record type results
  // if it also an influencer over the bucket.
  if (byFieldName !== undefined && overFieldName === undefined) {
    var _entitiesState$byFiel;
    const byFieldValue = (_entitiesState$byFiel = entitiesState === null || entitiesState === void 0 ? void 0 : entitiesState[byFieldName]) !== null && _entitiesState$byFiel !== void 0 ? _entitiesState$byFiel : null;
    entities.push({
      fieldType: 'by_field',
      fieldName: byFieldName,
      fieldValue: byFieldValue
    });
  }
  return entities;
}