"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInferenceInfoComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInferenceInfoComponent = (taskLabel, info) => /*#__PURE__*/_react.default.createElement(InferenceInfo, {
  taskLabel: taskLabel,
  info: info
});
exports.getInferenceInfoComponent = getInferenceInfoComponent;
const InferenceInfo = ({
  taskLabel,
  info
}) => {
  if (info.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: taskLabel
  }, info.map(i => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};