"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trueLabel = exports.falseLabel = exports.defaultLabel = exports.JobSectionTitle = exports.Italic = exports.DatafeedSectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trueLabel = _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.trueLabel', {
  defaultMessage: 'True'
});
exports.trueLabel = trueLabel;
const falseLabel = _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.falseLabel', {
  defaultMessage: 'False'
});
exports.falseLabel = falseLabel;
const defaultLabel = _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.defaultString', {
  defaultMessage: 'default'
});
exports.defaultLabel = defaultLabel;
const JobSectionTitle = () => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.newJob.wizard.summaryStep.jobConfig.title",
  defaultMessage: "Job configuration"
})));
exports.JobSectionTitle = JobSectionTitle;
const DatafeedSectionTitle = () => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.newJob.wizard.summaryStep.datafeedConfig.title",
  defaultMessage: "Datafeed configuration"
})));
exports.DatafeedSectionTitle = DatafeedSectionTitle;
const Italic = ({
  children
}) => /*#__PURE__*/_react.default.createElement("span", {
  style: {
    fontStyle: 'italic'
  }
}, children);
exports.Italic = Italic;