"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricDetectorsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _job_creator_context = require("../../../job_creator_context");
var _anomaly_chart = require("../../../charts/anomaly_chart");
var _settings = require("../../../charts/common/settings");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DTR_IDX = 0;
const SingleMetricDetectorsSummary = () => {
  const {
    jobCreator: jc,
    chartLoader,
    resultsLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [lineChartsData, setLineChartData] = (0, _react.useState)({});
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [modelData, setModelData] = (0, _react.useState)([]);
  const [anomalyData, setAnomalyData] = (0, _react.useState)([]);
  function setResultsWrapper(results) {
    const model = results.model[DTR_IDX];
    if (model !== undefined) {
      setModelData(model);
    }
    const anomalies = results.anomalies[DTR_IDX];
    if (anomalies !== undefined) {
      setAnomalyData(anomalies);
    }
  }
  (0, _react.useEffect)(() => {
    // subscribe to progress and results
    const subscription = resultsLoader.subscribeToResults(setResultsWrapper);
    loadChart();
    return () => {
      subscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [resultsLoader]);
  async function loadChart() {
    if (jobCreator.aggFieldPair !== null) {
      setLoadingData(true);
      try {
        const cs = (0, _settings.getChartSettings)(jobCreator, chartInterval);
        const resp = await chartLoader.loadLineCharts(jobCreator.start, jobCreator.end, [jobCreator.aggFieldPair], null, null, cs.intervalMs, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
        if (resp[DTR_IDX] !== undefined) {
          setLineChartData(resp);
        }
      } catch (error) {
        (0, _toast_notification_service.getToastNotificationService)().displayErrorToast(error);
        setLineChartData({});
      }
      setLoadingData(false);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, (lineChartsData[DTR_IDX] !== undefined || loadingData === true) && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_anomaly_chart.AnomalyChart, {
    chartType: _anomaly_chart.CHART_TYPE.LINE,
    chartData: lineChartsData[DTR_IDX],
    modelData: modelData,
    anomalyData: anomalyData,
    height: "300px",
    width: "100%",
    loading: loadingData
  })));
};
exports.SingleMetricDetectorsSummary = SingleMetricDetectorsSummary;