"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricDetectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _job_creator_context = require("../../../job_creator_context");
var _agg_select = require("../agg_select");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _anomaly_chart = require("../../../charts/anomaly_chart");
var _settings = require("../../../charts/common/settings");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DTR_IDX = 0;
const SingleMetricDetectors = ({
  setIsValid
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated,
    chartLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const fields = (0, _react.useMemo)(() => (0, _fields_utils.sortFields)([..._new_job_capabilities_service.newJobCapsService.fields, ...jobCreator.runtimeFields]),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(jobCreator.aggFieldPair !== null ? [{
    label: (0, _agg_select.createLabel)(jobCreator.aggFieldPair)
  }] : []);
  const [aggFieldPair, setAggFieldPair] = (0, _react.useState)(jobCreator.aggFieldPair);
  const [lineChartsData, setLineChartData] = (0, _react.useState)({});
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [start, setStart] = (0, _react.useState)(jobCreator.start);
  const [end, setEnd] = (0, _react.useState)(jobCreator.end);
  const [bucketSpanMs, setBucketSpanMs] = (0, _react.useState)(jobCreator.bucketSpanMs);
  function detectorChangeHandler(selectedOptionsIn) {
    setSelectedOptions(selectedOptionsIn);
    if (selectedOptionsIn.length) {
      const option = selectedOptionsIn[0];
      if (typeof option !== 'undefined') {
        setAggFieldPair({
          agg: option.agg,
          field: option.field
        });
      } else {
        setAggFieldPair(null);
      }
    }
  }
  (0, _react.useEffect)(() => {
    if (aggFieldPair !== null) {
      jobCreator.setDetector(aggFieldPair.agg, aggFieldPair.field);
      jobCreatorUpdate();
      loadChart();
      setIsValid(aggFieldPair !== null);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator, aggFieldPair]);
  (0, _react.useEffect)(() => {
    if (jobCreator.start !== start || jobCreator.end !== end) {
      setStart(jobCreator.start);
      setEnd(jobCreator.end);
      loadChart();
    }
    if (jobCreator.bucketSpanMs !== bucketSpanMs) {
      setBucketSpanMs(jobCreator.bucketSpanMs);
      loadChart();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator, jobCreatorUpdated]);
  async function loadChart() {
    if (aggFieldPair !== null) {
      setLoadingData(true);
      try {
        const cs = (0, _settings.getChartSettings)(jobCreator, chartInterval);
        const resp = await chartLoader.loadLineCharts(jobCreator.start, jobCreator.end, [aggFieldPair], null, null, cs.intervalMs, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
        if (resp[DTR_IDX] !== undefined) {
          setLineChartData(resp);
        }
      } catch (error) {
        (0, _toast_notification_service.getToastNotificationService)().displayErrorToast(error);
        setLineChartData({});
      }
      setLoadingData(false);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    fields: fields,
    changeHandler: detectorChangeHandler,
    selectedOptions: selectedOptions,
    removeOptions: []
  }), (lineChartsData[DTR_IDX] !== undefined || loadingData === true) && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_anomaly_chart.AnomalyChart, {
    chartType: _anomaly_chart.CHART_TYPE.LINE,
    chartData: lineChartsData[DTR_IDX],
    modelData: [],
    anomalyData: [],
    height: "300px",
    width: "100%",
    loading: loadingData
  })));
};
exports.SingleMetricDetectors = SingleMetricDetectors;