"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopulationDetectorsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_creator_context = require("../../../job_creator_context");
var _settings = require("../../../charts/common/settings");
var _chart_grid = require("./chart_grid");
var _toast_notification_service = require("../../../../../../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopulationDetectorsSummary = () => {
  const {
    jobCreator: jc,
    chartLoader,
    resultsLoader,
    chartInterval
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [aggFieldPairList, setAggFieldPairList] = (0, _react.useState)(jobCreator.aggFieldPairs);
  const [lineChartsData, setLineChartsData] = (0, _react.useState)({});
  const [loadingData, setLoadingData] = (0, _react.useState)(false);
  const [modelData, setModelData] = (0, _react.useState)([]);
  const [anomalyData, setAnomalyData] = (0, _react.useState)([]);
  const [chartSettings, setChartSettings] = (0, _react.useState)(_settings.defaultChartSettings);
  const [fieldValuesPerDetector, setFieldValuesPerDetector] = (0, _react.useState)({});
  function setResultsWrapper(results) {
    setModelData(results.model);
    setAnomalyData(results.anomalies);
  }
  (0, _react.useEffect)(() => {
    // subscribe to progress and results
    const subscription = resultsLoader.subscribeToResults(setResultsWrapper);
    return () => {
      subscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // watch for changes in by field values
  // redraw the charts if they change.
  // triggered when example fields have been loaded
  // if the split field or by fields have changed
  (0, _react.useEffect)(() => {
    if (allDataReady()) {
      loadCharts();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(fieldValuesPerDetector), jobCreator.populationField]);

  // watch for changes in split field or by fields.
  // load example field values
  // changes to fieldValues here will trigger the card effect via setFieldValuesPerDetector
  (0, _react.useEffect)(() => {
    loadFieldExamples();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreator.populationField]);
  async function loadCharts() {
    if (allDataReady()) {
      setLoadingData(true);
      try {
        const cs = (0, _settings.getChartSettings)(jobCreator, chartInterval);
        setChartSettings(cs);
        const resp = await chartLoader.loadPopulationCharts(jobCreator.start, jobCreator.end, aggFieldPairList, jobCreator.populationField, cs.intervalMs, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options);
        setLineChartsData(resp);
      } catch (error) {
        (0, _toast_notification_service.getToastNotificationService)().displayErrorToast(error);
        setLineChartsData({});
      }
      setLoadingData(false);
    }
  }
  async function loadFieldExamples() {
    const promises = [];
    aggFieldPairList.forEach((af, i) => {
      if (af.by !== undefined && af.by.field !== null) {
        promises.push((async (index, field) => {
          return {
            index,
            fields: await chartLoader.loadFieldExampleValues(field, jobCreator.runtimeMappings, jobCreator.datafeedConfig.indices_options)
          };
        })(i, af.by.field));
      }
    });
    const results = await Promise.all(promises);
    const fieldValues = results.reduce((p, c) => {
      p[c.index] = c.fields;
      return p;
    }, {});
    const newPairs = aggFieldPairList.map((pair, i) => ({
      ...pair,
      ...(pair.by === undefined || pair.by.field === null ? {} : {
        by: {
          ...pair.by,
          value: fieldValues[i][0]
        }
      })
    }));
    setAggFieldPairList([...newPairs]);
    setFieldValuesPerDetector(fieldValues);
  }
  function allDataReady() {
    let ready = aggFieldPairList.length > 0;
    aggFieldPairList.forEach(af => {
      if (af.by !== undefined && af.by.field !== null) {
        // if a by field is set, it's only ready when the value is loaded
        ready = ready && af.by.value !== null;
      }
    });
    return ready;
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, jobCreator.populationField !== null && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.populationView.splitFieldTitle",
    defaultMessage: "Population split by {field}",
    values: {
      field: jobCreator.populationField.name
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_chart_grid.ChartGrid, {
    aggFieldPairList: jobCreator.aggFieldPairs,
    chartSettings: chartSettings,
    splitField: jobCreator.populationField,
    lineChartsData: lineChartsData,
    modelData: modelData,
    anomalyData: anomalyData,
    jobType: jobCreator.type,
    fieldValuesPerDetector: fieldValuesPerDetector,
    loading: loadingData
  })));
};
exports.PopulationDetectorsSummary = PopulationDetectorsSummary;