"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionHelpPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FunctionHelpPopover = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(false);
  const onHelpClick = () => setIsHelpOpen(prevIsHelpOpen => !prevIsHelpOpen);
  const closeHelp = () => setIsHelpOpen(false);
  const helpButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onHelpClick,
    iconType: "help"
  });
  const columns = [{
    field: 'function',
    name: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.function', {
      defaultMessage: 'Function'
    }),
    width: '150px'
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.description', {
      defaultMessage: 'Description'
    })
  }];
  const items = [{
    function: 'count, high_count, low_count',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.count', {
      defaultMessage: 'Detect anomalies when the number of events in a bucket is anomalous.'
    })
  }, {
    function: 'non_zero_count, high_non_zero_count, low_non_zero_count',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.nonZeroCount', {
      defaultMessage: 'Detect anomalies when the number of events in a bucket is anomalous, but ignore cases where the bucket count is zero.'
    })
  }, {
    function: 'distinct_count, high_distinct_count, low_distinct_count',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.distinctCount', {
      defaultMessage: 'Detect anomalies where the number of distinct values in one field is unusual.'
    })
  }, {
    function: 'lat_long',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.latLong', {
      defaultMessage: 'Detect anomalies in the geographic location of the input data.'
    })
  }, {
    function: 'info_content, high_info_content, low_info_content',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.infoContent', {
      defaultMessage: 'Detect anomalies in the amount of information that is contained in strings in a bucket.'
    })
  }, {
    function: 'min',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.min', {
      defaultMessage: 'Detect anomalies in the arithmetic minimum of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'max',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.max', {
      defaultMessage: 'Detect anomalies in the arithmetic maximum of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'median, high_median, low_median',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.median', {
      defaultMessage: 'Detect anomalies in the statistical median of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'mean, high_mean, low_mean',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.mean', {
      defaultMessage: 'Detect anomalies in the arithmetic mean of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'metric',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.metric', {
      defaultMessage: 'Combine min, max, and mean functions. Use it as a shorthand for a combined analysis. This is the default function.'
    })
  }, {
    function: 'varp, high_varp, low_varp',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.varp', {
      defaultMessage: 'Detect anomalies in the variance of a value which is a measure of the variability and spread in the data.'
    })
  }, {
    function: 'rare',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.rare', {
      defaultMessage: 'Detect anomalies according to the number of distinct rare values.'
    })
  }, {
    function: 'freq_rare',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.freqRare', {
      defaultMessage: 'Detect anomalies according to the number of times (frequency) rare values occur.'
    })
  }, {
    function: 'sum, high_sum, low_sum',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.sum', {
      defaultMessage: 'Detect anomalies where the sum of a field in a bucket is anomalous.'
    })
  }, {
    function: 'non_null_sum, high_non_null_sum, low_non_null_sum',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.nonNullSum', {
      defaultMessage: 'These functions are useful if your data is sparse. Buckets without values are ignored and buckets with a zero value are analyzed.'
    })
  }, {
    function: 'time_of_day, time_of_week',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.time', {
      defaultMessage: 'Detect events that happen at unusual times, either of the day or of the week.'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "rightUp",
    button: helpButton,
    isOpen: isHelpOpen,
    display: "inlineBlock",
    panelPaddingSize: "none",
    closePopover: closeHelp,
    initialFocus: "#mlAdFunctionsHelpTableId"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.functions.popoverTitle",
    defaultMessage: "Function reference"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "eui-yScroll",
    css: {
      maxHeight: '40vh'
    },
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    id: "mlAdFunctionsHelpTableId",
    css: {
      width: 400
    },
    tableCaption: _i18n.i18n.translate('xpack.ml.anomalyDetection.functions.tableTitle', {
      defaultMessage: 'Description of functions'
    }),
    items: items,
    compressed: true,
    columns: columns,
    responsive: false
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.functions.learnMoreText",
    defaultMessage: "Learn more about {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.ml.anomalyDetectionFunctions,
        target: "_blank",
        external: true
      }, _i18n.i18n.translate('xpack.ml.anomalyDetection.functions.learnMoreLink', {
        defaultMessage: 'functions'
      }))
    }
  }))));
});
exports.FunctionHelpPopover = FunctionHelpPopover;