"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobIdInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobIdInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [jobId, setJobId] = (0, _react.useState)(jobCreator.jobId);
  const validation = (0, _react.useMemo)(() => {
    var _jobValidator$latestV, _jobValidator$jobId$m, _jobValidator$latestV2;
    const isEmptyId = jobId === '';
    const valid = isEmptyId === true || jobValidator.jobId.valid === true && ((_jobValidator$latestV = jobValidator.latestValidationResult.jobIdExists) === null || _jobValidator$latestV === void 0 ? void 0 : _jobValidator$latestV.valid) === true;
    const message = (_jobValidator$jobId$m = jobValidator.jobId.message) !== null && _jobValidator$jobId$m !== void 0 ? _jobValidator$jobId$m : (_jobValidator$latestV2 = jobValidator.latestValidationResult.jobIdExists) === null || _jobValidator$latestV2 === void 0 ? void 0 : _jobValidator$latestV2.message;
    return {
      valid,
      message
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  (0, _react.useEffect)(() => {
    jobCreator.jobId = jobId;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: jobId,
    onChange: e => setJobId(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputJobId"
  }));
};
exports.JobIdInput = JobIdInput;