"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrlsSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _dashboard_service = require("../../../../../../../../../services/dashboard_service");
var _custom_urls = require("../../../../../../../../../components/custom_urls/custom_urls");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomUrlsSelection = () => {
  var _jobCreator$customUrl;
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const setCustomUrls = customUrls => {
    jobCreator.customUrls = customUrls;
    jobCreatorUpdate();
  };
  const combinedJob = {
    ...jobCreator.jobConfig,
    datafeed_config: jobCreator.datafeedConfig
  };
  const dashboardService = (0, _dashboard_service.useDashboardService)();
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_custom_urls.CustomUrls, {
    job: combinedJob,
    jobCustomUrls: (_jobCreator$customUrl = jobCreator.customUrls) !== null && _jobCreator$customUrl !== void 0 ? _jobCreator$customUrl : [],
    setCustomUrls: setCustomUrls,
    editMode: "modal",
    dashboardService: dashboardService
  }));
};
exports.CustomUrlsSelection = CustomUrlsSelection;