"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatafeedStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _wizard_nav = require("../wizard_nav");
var _query = require("./components/query");
var _query_delay = require("./components/query_delay");
var _frequency = require("./components/frequency");
var _scroll_size = require("./components/scroll_size");
var _reset_query = require("./components/reset_query");
var _time_field = require("./components/time_field");
var _data_view = require("./components/data_view");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _json_editor_flyout = require("../common/json_editor_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatafeedStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const {
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [nextActive, setNextActive] = (0, _react.useState)(false);
  const [isValidQuery, setIsValidQuery] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const active = isValidQuery && jobValidator.queryDelay.valid && jobValidator.frequency.valid && jobValidator.scrollSize.valid && jobValidator.validating === false;
    setNextActive(active);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated, isValidQuery]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlAdvancedDatafeedQueryEditor"
  }, /*#__PURE__*/_react.default.createElement(_query.QueryInput, {
    setIsValidQuery: setIsValidQuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_delay.QueryDelayInput, null), /*#__PURE__*/_react.default.createElement(_frequency.FrequencyInput, null), /*#__PURE__*/_react.default.createElement(_scroll_size.ScrollSizeInput, null), /*#__PURE__*/_react.default.createElement(_time_field.TimeField, null), /*#__PURE__*/_react.default.createElement(_data_view.ChangeDataView, {
    isDisabled: false
  }))), /*#__PURE__*/_react.default.createElement(_reset_query.ResetQueryButton, null), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    next: () => setCurrentStep(_step_types.WIZARD_STEPS.PICK_FIELDS),
    nextActive: nextActive
  }, /*#__PURE__*/_react.default.createElement(_json_editor_flyout.JsonEditorFlyout, {
    isDisabled: false,
    jobEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE,
    datafeedEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE
  }))));
};
exports.DatafeedStep = DatafeedStep;