"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatafeedPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ml_job_editor = require("../../../../../jobs_list/components/ml_job_editor");
var _kibana = require("../../../../../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatafeedPreview = ({
  combinedJob,
  heightOffset = 0
}) => {
  const {
    jobs: {
      datafeedPreview
    }
  } = (0, _kibana.useMlApiContext)();
  // the ace editor requires a fixed height
  const editorHeight = (0, _react.useMemo)(() => `${window.innerHeight - 230 - heightOffset}px`, [heightOffset]);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [previewJsonString, setPreviewJsonString] = (0, _react.useState)('');
  const [outOfDate, setOutOfDate] = (0, _react.useState)(false);
  const [combinedJobString, setCombinedJobString] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    try {
      if (combinedJob !== null) {
        if (combinedJobString === '') {
          // first time, set the string and load the preview
          loadDataPreview();
        } else {
          setOutOfDate(JSON.stringify(combinedJob) !== combinedJobString);
        }
      }
    } catch (error) {
      // fail silently
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [combinedJob]);
  const loadDataPreview = (0, _react.useCallback)(async () => {
    setPreviewJsonString('');
    if (combinedJob === null) {
      return;
    }
    setLoading(true);
    setCombinedJobString(JSON.stringify(combinedJob));
    if (combinedJob.datafeed_config && combinedJob.datafeed_config.indices.length) {
      try {
        const {
          datafeed_config: datafeed,
          ...job
        } = combinedJob;
        if (job.analysis_config.detectors.length === 0) {
          setPreviewJsonString(_i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedPreviewFlyout.noDetectors', {
            defaultMessage: 'No detectors configured'
          }));
        } else {
          const preview = await datafeedPreview(undefined, job, datafeed);
          setPreviewJsonString(JSON.stringify(preview, null, 2));
        }
      } catch (error) {
        setPreviewJsonString(JSON.stringify(error, null, 2));
      }
      setLoading(false);
      setOutOfDate(false);
    } else {
      const errorText = _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedPreviewFlyout.datafeedDoesNotExistLabel', {
        defaultMessage: 'Datafeed does not exist'
      });
      setPreviewJsonString(errorText);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [combinedJob]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedPreviewFlyout.title",
    defaultMessage: "Datafeed preview"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, outOfDate && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: loadDataPreview,
    iconType: "refresh"
  }, "Refresh"))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), loading === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }))) : /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: previewJsonString,
    height: editorHeight,
    readOnly: true
  }));
};
exports.DatafeedPreview = DatafeedPreview;