"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopulationJobCreator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _job_creator = require("./job_creator");
var _default_configs = require("./util/default_configs");
var _new_job = require("../../../../../../common/constants/new_job");
var _general = require("./util/general");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PopulationJobCreator extends _job_creator.JobCreator {
  // a population job has one overall over (split) field, which is the same for all detectors
  // each detector has an optional by field

  constructor(indexPattern, savedSearch, query) {
    super(indexPattern, savedSearch, query);
    (0, _defineProperty2.default)(this, "_populatonField", null);
    (0, _defineProperty2.default)(this, "_byFields", []);
    (0, _defineProperty2.default)(this, "_type", _new_job.JOB_TYPE.POPULATION);
    this.createdBy = _new_job.CREATED_BY_LABEL.POPULATION;
    this._wizardInitialized$.next(true);
  }

  // add a by field to a specific detector
  setByField(field, index) {
    if (field === null) {
      this.removeByField(index);
    } else {
      if (this._detectors[index] !== undefined) {
        this._byFields[index] = field;
        this._detectors[index].by_field_name = field.id;
      }
    }
  }

  // remove a by field from a specific detector
  removeByField(index) {
    if (this._detectors[index] !== undefined) {
      this._byFields[index] = null;
      delete this._detectors[index].by_field_name;
    }
  }

  // get the by field for a specific detector
  getByField(index) {
    if (this._byFields[index] === undefined) {
      return null;
    }
    return this._byFields[index];
  }

  // add an over field to all detectors
  setPopulationField(field) {
    this._populatonField = field;
    if (this._populatonField === null) {
      this.removePopulationField();
    } else {
      for (let i = 0; i < this._detectors.length; i++) {
        this._detectors[i].over_field_name = this._populatonField.id;
      }
    }
  }

  // remove over field from all detectors
  removePopulationField() {
    this._detectors.forEach(d => {
      delete d.over_field_name;
    });
  }
  get populationField() {
    return this._populatonField;
  }
  addDetector(agg, field) {
    const dtr = this._createDetector(agg, field);
    this._addDetector(dtr, agg, field);
    this._byFields.push(null);
  }

  // edit a specific detector, reapplying the by field
  // already set on the the detector at that index
  editDetector(agg, field, index) {
    const dtr = this._createDetector(agg, field);
    const sp = this._byFields[index];
    if (sp !== undefined && sp !== null) {
      dtr.by_field_name = sp.id;
    }
    this._editDetector(dtr, agg, field, index);
  }

  // create a detector object, adding the current over field
  _createDetector(agg, field) {
    const dtr = (0, _default_configs.createBasicDetector)(agg, field);
    if (this._populatonField !== null) {
      dtr.over_field_name = this._populatonField.id;
    }
    return dtr;
  }
  removeDetector(index) {
    this._removeDetector(index);
    this._byFields.splice(index, 1);
  }
  get aggFieldPairs() {
    return this.detectors.map((d, i) => ({
      field: this._fields[i],
      agg: this._aggs[i],
      by: {
        field: this._byFields[i],
        value: null
      }
    }));
  }
  cloneFromExistingJob(job, datafeed) {
    this._overrideConfigs(job, datafeed);
    this.createdBy = _new_job.CREATED_BY_LABEL.POPULATION;
    const detectors = (0, _general.getRichDetectors)(job, datafeed, this.additionalFields, false);
    this.removeAllDetectors();
    if (detectors.length) {
      if (detectors[0].overField !== null) {
        this.setPopulationField(detectors[0].overField);
      }
    }
    detectors.forEach((d, i) => {
      const dtr = detectors[i];
      if (dtr.agg !== null && dtr.field !== null) {
        this.addDetector(dtr.agg, dtr.field);
        if (dtr.byField !== null) {
          this.setByField(dtr.byField, i);
        }
      }
    });
  }
}
exports.PopulationJobCreator = PopulationJobCreator;