"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewGroupInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _validate_job = require("../../../validate_job");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class NewGroupInput extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "changeTempNewGroup", e => {
      const tempNewGroupName = e.target.value;
      let groupsValidationError = '';
      if (tempNewGroupName === '') {
        groupsValidationError = '';
      } else if (this.props.allJobIds.includes(tempNewGroupName)) {
        groupsValidationError = _i18n.i18n.translate('xpack.ml.jobsList.multiJobActions.groupSelector.groupsAndJobsCanNotUseSameIdErrorMessage', {
          defaultMessage: 'A job with this ID already exists. Groups and jobs cannot use the same ID.'
        });
      } else {
        groupsValidationError = (0, _validate_job.validateGroupNames)([tempNewGroupName]).message;
      }
      this.setState({
        tempNewGroupName,
        groupsValidationError
      });
    });
    (0, _defineProperty2.default)(this, "newGroupKeyPress", e => {
      if (e.key === _eui.keys.ENTER && this.state.groupsValidationError === '' && this.state.tempNewGroupName !== '') {
        this.addNewGroup();
      }
    });
    (0, _defineProperty2.default)(this, "addNewGroup", () => {
      this.props.addNewGroup(this.state.tempNewGroupName);
      this.setState({
        tempNewGroupName: ''
      });
    });
    this.state = {
      tempNewGroupName: '',
      groupsValidationError: ''
    };
  }
  render() {
    const {
      tempNewGroupName,
      groupsValidationError
    } = this.state;
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      isInvalid: groupsValidationError !== '',
      error: groupsValidationError,
      className: "new-group-input"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      placeholder: _i18n.i18n.translate('xpack.ml.jobsList.multiJobActions.groupSelector.addNewGroupPlaceholder', {
        defaultMessage: 'Add new group'
      }),
      value: tempNewGroupName,
      onChange: this.changeTempNewGroup,
      onKeyDown: this.newGroupKeyPress,
      isInvalid: groupsValidationError !== '',
      error: groupsValidationError
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "new-group-input"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: this.addNewGroup,
      iconType: "plusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.multiJobActions.groupSelector.addButtonAriaLabel', {
        defaultMessage: 'Add'
      }),
      disabled: tempNewGroupName === '' || groupsValidationError !== ''
    })))));
  }
}
exports.NewGroupInput = NewGroupInput;
(0, _defineProperty2.default)(NewGroupInput, "propTypes", {
  addNewGroup: _propTypes.default.func.isRequired,
  allJobIds: _propTypes.default.array.isRequired
});