"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobFilterBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _job_group = require("../job_group");
var _kibana = require("../../../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobFilterBar = ({
  queryText,
  setFilters
}) => {
  const [error, setError] = (0, _react.useState)(null);
  const {
    services: {
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _kibana.useMlKibana)();
  const loadGroups = (0, _react.useCallback)(async () => {
    try {
      const response = await mlApiServices.jobs.groups();
      return response.map(g => ({
        value: g.id,
        view: /*#__PURE__*/_react.default.createElement("div", {
          className: "group-item"
        }, /*#__PURE__*/_react.default.createElement(_job_group.JobGroup, {
          name: g.id
        }), "\xA0", /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.jobsList.jobFilterBar.jobGroupTitle",
          defaultMessage: "({jobsCount, plural, one {# job} other {# jobs}})",
          values: {
            jobsCount: g.jobIds.length
          }
        })))
      }));
    } catch (e) {
      return [];
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const queryInstance = (0, _react.useMemo)(() => {
    return _eui.EuiSearchBar.Query.parse(queryText !== null && queryText !== void 0 ? queryText : '');
  }, [queryText]);
  const onChange = ({
    query,
    error: queryError
  }) => {
    if (queryError) {
      setError(queryError);
    } else {
      setFilters(query);
      setError(null);
    }
  };
  (0, _react.useEffect)(() => {
    if (queryText !== undefined) {
      setFilters(queryInstance);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [queryText]);
  const filters = (0, _react.useMemo)(() => [{
    type: 'field_value_toggle_group',
    field: 'job_state',
    items: [{
      value: 'opened',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.openedLabel', {
        defaultMessage: 'Opened'
      })
    }, {
      value: 'closed',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.closedLabel', {
        defaultMessage: 'Closed'
      })
    }, {
      value: 'failed',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.failedLabel', {
        defaultMessage: 'Failed'
      })
    }]
  }, {
    type: 'field_value_toggle_group',
    field: 'datafeed_state',
    items: [{
      value: 'started',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.startedLabel', {
        defaultMessage: 'Started'
      })
    }, {
      value: 'stopped',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.stoppedLabel', {
        defaultMessage: 'Stopped'
      })
    }]
  }, {
    type: 'field_value_selection',
    field: 'groups',
    name: _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.groupLabel', {
      defaultMessage: 'Group'
    }),
    multiSelect: 'or',
    cache: 10000,
    options: () => loadGroups()
  }],
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const errorText = (0, _react.useMemo)(() => {
    if (error === null) return '';
    return _i18n.i18n.translate('xpack.ml.jobsList.jobFilterBar.invalidSearchErrorMessage', {
      defaultMessage: 'Invalid search: {errorMessage}',
      values: {
        errorMessage: error.message
      }
    });
  }, [error]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlJobListSearchBar",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      incremental: true
    },
    query: queryInstance,
    filters: filters,
    onChange: onChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: error !== null,
    error: errorText,
    style: {
      maxHeight: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null))));
};
exports.JobFilterBar = JobFilterBar;