"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerQueryBar = exports.DEFAULT_QUERY_LANG = void 0;
exports.getKqlQueryValues = getKqlQueryValues;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/unified-search-plugin/public");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _app = require("../../../../../common/constants/app");
var _anomaly_explorer_context = require("../../anomaly_explorer_context");
var _kibana = require("../../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERY_LANG = _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY;
exports.DEFAULT_QUERY_LANG = DEFAULT_QUERY_LANG;
function getKqlQueryValues({
  inputString,
  queryLanguage,
  indexPattern
}) {
  var _influencersFilterQue;
  let influencersFilterQuery = {};
  const filteredFields = [];
  const ast = (0, _esQuery.fromKueryExpression)(inputString);
  const isAndOperator = ast && ast.function === 'and';
  // if ast.type == 'function' then layout of ast.arguments:
  // [{ arguments: [ { type: 'literal', value: 'AAL' } ] },{ arguments: [ { type: 'literal', value: 'AAL' } ] }]
  if (ast && Array.isArray(ast.arguments)) {
    ast.arguments.forEach(arg => {
      if (arg.arguments !== undefined) {
        arg.arguments.forEach(nestedArg => {
          if (typeof nestedArg.value === 'string') {
            filteredFields.push(nestedArg.value);
          }
        });
      } else if (typeof arg.value === 'string') {
        filteredFields.push(arg.value);
      }
    });
  }
  if (queryLanguage === _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY) {
    influencersFilterQuery = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(inputString), indexPattern);
  } else if (queryLanguage === _mlQueryUtils.SEARCH_QUERY_LANGUAGE.LUCENE) {
    influencersFilterQuery = (0, _esQuery.luceneStringToDsl)(inputString);
  }
  const clearSettings = Boolean(((_influencersFilterQue = influencersFilterQuery) === null || _influencersFilterQue === void 0 ? void 0 : _influencersFilterQue.match_all) && Object.keys(influencersFilterQuery.match_all).length === 0);
  return {
    clearSettings,
    settings: {
      filterQuery: influencersFilterQuery,
      queryString: inputString,
      tableQueryString: inputString,
      isAndOperator,
      filteredFields
    }
  };
}
function getInitSearchInputState({
  queryString,
  searchInput
}) {
  var _searchInput$language;
  return {
    language: (_searchInput$language = searchInput === null || searchInput === void 0 ? void 0 : searchInput.language) !== null && _searchInput$language !== void 0 ? _searchInput$language : DEFAULT_QUERY_LANG,
    query: queryString !== null && queryString !== void 0 ? queryString : ''
  };
}
const ExplorerQueryBar = ({
  filterActive,
  filterPlaceHolder,
  indexPattern,
  queryString,
  updateLanguage,
  dataViews = []
}) => {
  const {
    anomalyExplorerCommonStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    unifiedSearch,
    data,
    storage,
    notifications,
    http,
    docLinks,
    uiSettings,
    dataViews: dataViewsService
  } = services;

  // The internal state of the input query bar updated on every key stroke.
  const [searchInput, setSearchInput] = (0, _react.useState)(getInitSearchInputState({
    queryString
  }));
  const [queryErrorMessage, setQueryErrorMessage] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(function updateSearchInputFromFilter() {
    setSearchInput(getInitSearchInputState({
      queryString,
      searchInput
    }));
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [queryString, searchInput.language]);
  const searchChangeHandler = query => {
    if (searchInput.language !== query.language) {
      updateLanguage(query.language);
    }
    setSearchInput(query);
  };
  const applyInfluencersFilterQuery = query => {
    try {
      const {
        clearSettings,
        settings
      } = getKqlQueryValues({
        inputString: query.query,
        queryLanguage: query.language,
        indexPattern
      });
      if (clearSettings === true) {
        anomalyExplorerCommonStateService.clearFilterSettings();
      } else {
        anomalyExplorerCommonStateService.setFilterSettings(settings);
      }
    } catch (e) {
      console.log('Invalid query syntax in search bar', e); // eslint-disable-line no-console
      setQueryErrorMessage({
        query: query.query,
        message: e.message
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    css: {
      'max-width': '100%'
    },
    closePopover: setQueryErrorMessage.bind(null, undefined),
    input: /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
      bubbleSubmitEvent: false,
      query: searchInput,
      indexPatterns: dataViews !== null && dataViews !== void 0 ? dataViews : [],
      onChange: searchChangeHandler,
      onSubmit: applyInfluencersFilterQuery,
      placeholder: filterPlaceHolder,
      disableAutoFocus: true,
      dataTestSubj: "explorerQueryInput",
      languageSwitcherPopoverAnchorPosition: "rightDown",
      appName: _app.PLUGIN_ID,
      deps: {
        unifiedSearch,
        notifications,
        http,
        docLinks,
        uiSettings,
        data,
        storage,
        dataViews: dataViewsService
      }
    }),
    isOpen: (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.query) === searchInput.query && (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message) !== ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _i18n.i18n.translate('xpack.ml.explorer.invalidKuerySyntaxErrorMessageQueryBar', {
    defaultMessage: 'Invalid query'
  }), ': ', queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message.split('\n')[0]));
};
exports.ExplorerQueryBar = ExplorerQueryBar;