"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatavisualizerSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _license = require("../license");
var _kibana = require("../contexts/kibana");
var _help_menu = require("../components/help_menu");
var _page_header = require("../components/page_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function startTrialDescription() {
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.startTrial.fullMLFeaturesDescription",
    defaultMessage: "To experience the full Machine Learning features that a {subscriptionsLink} offers, start a 30-day trial.",
    values: {
      subscriptionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.datavisualizer.startTrial.subscriptionsLinkText",
        defaultMessage: "Platinum or Enterprise subscription"
      }))
    }
  }));
}
const DatavisualizerSelector = () => {
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const {
    services: {
      licenseManagement,
      http: {
        basePath
      },
      docLinks,
      dataVisualizer
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.guide;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const startTrialVisible = licenseManagement !== undefined && licenseManagement.enabled === true && (0, _license.isFullLicense)() === false;
  if (dataVisualizer === undefined) {
    // eslint-disable-next-line no-console
    console.error('File data visualizer plugin not available');
    return null;
  }
  const maxFileSize = dataVisualizer.getMaxBytesFormatted();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageDataVisualizerSelector"
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.dataVisualizerTitle",
    defaultMessage: "Data Visualizer"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.datavisualizer.selector.dataVisualizerDescription",
    defaultMessage: "The Machine Learning Data Visualizer tool helps you understand your data, by analyzing the metrics and fields in a log file or an existing Elasticsearch index."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "xl",
    columns: 2,
    style: {
      maxWidth: '1000px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "addDataApp"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.importDataTitle",
      defaultMessage: "Visualize data from a file"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.importDataDescription",
      defaultMessage: "Import data from a log file. You can upload files up to {maxFileSize}.",
      values: {
        maxFileSize
      }
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      target: "_self",
      onClick: () => navigateToPath('/filedatavisualizer'),
      "data-test-subj": "mlDataVisualizerUploadFileButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.uploadFileButtonLabel",
      defaultMessage: "Select file"
    })),
    "data-test-subj": "mlDataVisualizerCardImportData"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "dataVisualizer"
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.selectDataViewTitle",
      defaultMessage: "Visualize data from a data view"
    }),
    description: '',
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      target: "_self",
      onClick: () => navigateToPath('/datavisualizer_index_select'),
      "data-test-subj": "mlDataVisualizerSelectIndexButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.selectDataViewButtonLabel",
      defaultMessage: "Select data view"
    })),
    "data-test-subj": "mlDataVisualizerCardIndexData"
  }))), startTrialVisible === true && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "xl",
    columns: 2,
    style: {
      maxWidth: '1000px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.startTrialTitle",
      defaultMessage: "Start trial"
    }),
    description: startTrialDescription(),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      target: "_blank",
      href: `${basePath.get()}/app/management/stack/license_management/home`,
      "data-test-subj": "mlDataVisualizerStartTrialButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.datavisualizer.selector.startTrialButtonLabel",
      defaultMessage: "Start trial"
    })),
    "data-test-subj": "mlDataVisualizerCardStartTrial"
  }))))), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};
exports.DatavisualizerSelector = DatavisualizerSelector;