"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowMessagesPane = void 0;
require("./expanded_row_messages_pane.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _ml_api_service = require("../../../../../services/ml_api_service");
var _common = require("../../../../common");
var _job_messages = require("../../../../../components/job_messages");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRowMessagesPane = ({
  analyticsId,
  dataTestSubj
}) => {
  const [messages, setMessages] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)('');
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const getMessages = (0, _react.useCallback)(async () => {
    try {
      setIsLoading(true);
      const messagesResp = await _ml_api_service.ml.dataFrameAnalytics.getAnalyticsAuditMessages(analyticsId);
      setIsLoading(false);
      setMessages(messagesResp);
    } catch (error) {
      setIsLoading(false);
      toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.dfAnalyticsList.analyticsDetails.messagesPane.errorToastMessageTitle', {
        defaultMessage: 'Error loading job messages'
      }));
      setErrorMessage(_i18n.i18n.translate('xpack.ml.dfAnalyticsList.analyticsDetails.messagesPane.errorMessage', {
        defaultMessage: 'Messages could not be loaded'
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    getMessages();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _common.useRefreshAnalyticsList)({
    onRefresh: getMessages
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mlExpandedRowJobMessages",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_job_messages.JobMessages, {
    messages: messages,
    loading: isLoading,
    error: errorMessage,
    refreshMessage: getMessages
  }));
};
exports.ExpandedRowMessagesPane = ExpandedRowMessagesPane;