"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Stats = exports.Section = exports.OverallDetails = exports.ExpandedRowDetailsPane = void 0;
require("./expanded_row_details_pane.scss");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverallDetails = ({
  overallDetails
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  wrap: true,
  "data-test-subj": overallDetails.dataTestSubj
}, overallDetails.items.map(item => {
  if (item.title === 'badge') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: item.description,
      color: "subdued",
      title: item.title
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "descriptionListTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, item.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "descriptionListDescription"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, item.description))))));
}));
exports.OverallDetails = OverallDetails;
const Stats = ({
  section
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s",
  "data-test-subj": section.dataTestSubj
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("span", null, section.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, section.items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
  className: "descriptionListTitle"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, item.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
  className: "descriptionListDescription"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h5", null, item.description))))))));
exports.Stats = Stats;
const Section = ({
  section
}) => {
  if (section !== null && section !== void 0 && section.items && section.items.length === 0) {
    return null;
  }
  const columns = [{
    field: 'title',
    name: ''
  }, {
    field: 'description',
    name: '',
    render: v => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, v)
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": section.dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, section.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    compressed: true,
    items: section.items,
    columns: columns,
    tableCaption: section.title,
    tableLayout: "auto",
    className: "mlExpandedRowDetailsSection",
    "data-test-subj": `${section.dataTestSubj}-table`
  }));
};
exports.Section = Section;
const ExpandedRowDetailsPane = ({
  analysisStats,
  dataCounts,
  memoryUsage,
  overallDetails,
  progress,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "mlExpandedRowDetails",
    "data-test-subj": dataTestSubj,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OverallDetails, {
    overallDetails: overallDetails
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Stats, {
    section: dataCounts
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Stats, {
    section: memoryUsage
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-test-subj": progress.dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, progress.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), progress.items.map(item => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, item.description, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), analysisStats ? /*#__PURE__*/_react.default.createElement(Section, {
    section: analysisStats
  }) : null)))));
};
exports.ExpandedRowDetailsPane = ExpandedRowDetailsPane;