"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("../analytics_list/common");
var _analytics_service = require("../../services/analytics_service");
var _stop_action_name = require("./stop_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStopAction = canStartStopDataFrameAnalytics => {
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [item, setItem] = (0, _react.useState)();
  const closeModal = () => setModalVisible(false);
  const forceStopAndCloseModal = () => {
    if (item !== undefined) {
      setModalVisible(false);
      (0, _analytics_service.stopAnalytics)(item);
    }
  };
  const openModal = newItem => {
    setItem(newItem);
    setModalVisible(true);
  };
  const clickHandler = (0, _react.useCallback)(i => {
    if (canStartStopDataFrameAnalytics) {
      if ((0, _common.isDataFrameAnalyticsFailed)(i.stats.state)) {
        openModal(i);
      } else {
        (0, _analytics_service.stopAnalytics)(i);
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [_analytics_service.stopAnalytics]);
  const action = (0, _react.useMemo)(() => ({
    name: () => /*#__PURE__*/_react.default.createElement(_stop_action_name.StopActionName, {
      isDisabled: !canStartStopDataFrameAnalytics
    }),
    available: i => (0, _common.isDataFrameAnalyticsRunning)(i.stats.state) || (0, _common.isDataFrameAnalyticsFailed)(i.stats.state),
    enabled: () => canStartStopDataFrameAnalytics,
    description: _stop_action_name.stopActionNameText,
    icon: 'stop',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'mlAnalyticsJobStopButton'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [clickHandler]);
  return {
    action,
    closeModal,
    isModalVisible,
    item,
    openModal,
    forceStopAndCloseModal
  };
};
exports.useStopAction = useStopAction;