"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassificationExploration = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _exploration_page_wrapper = require("../exploration_page_wrapper");
var _evaluate_panel = require("./evaluate_panel");
var _feature_importance_summary = require("../total_feature_importance_summary/feature_importance_summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClassificationExploration = ({
  jobId
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "mlDataFrameAnalyticsClassification"
}, /*#__PURE__*/_react.default.createElement(_exploration_page_wrapper.ExplorationPageWrapper, {
  jobId: jobId,
  title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.tableJobIdTitle', {
    defaultMessage: 'Destination index for classification job ID {jobId}',
    values: {
      jobId
    }
  }),
  EvaluatePanel: _evaluate_panel.EvaluatePanel,
  FeatureImportanceSummaryPanel: _feature_importance_summary.FeatureImportanceSummaryPanel
}));
exports.ClassificationExploration = ClassificationExploration;