"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsStepDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _page = require("../../page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsStepDetails = ({
  setCurrentStep,
  state
}) => {
  const {
    form,
    isJobCreated
  } = state;
  const {
    description,
    jobId,
    destinationIndex,
    resultsField
  } = form;
  const detailsFirstCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.jobId', {
      defaultMessage: 'Job ID'
    }),
    description: jobId
  }];
  if (resultsField !== undefined && typeof resultsField === 'string' && resultsField.trim() !== '') {
    detailsFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.resultsField', {
        defaultMessage: 'Results field'
      }),
      description: resultsField
    });
  }
  const detailsSecondCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.jobDescription', {
      defaultMessage: 'Job description'
    }),
    description
  }];
  const detailsThirdCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.destIndex', {
      defaultMessage: 'Destination index'
    }),
    description: destinationIndex || ''
  }];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsFirstCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    style: {
      wordBreak: 'break-word'
    },
    compressed: true,
    listItems: detailsSecondCol
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsThirdCol
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !isJobCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "s",
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.DETAILS);
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.detailsDetails.editButtonText', {
    defaultMessage: 'Edit'
  })));
};
exports.DetailsStepDetails = DetailsStepDetails;