"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMlLocator = exports.useMlLink = exports.useCreateAndNavigateToMlLink = void 0;
var _react = require("react");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana_context = require("./kibana_context");
var _locator = require("../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMlLocator = () => {
  const {
    services: {
      share
    }
  } = (0, _kibana_context.useMlKibana)();
  return share.url.locators.get(_locator.ML_APP_LOCATOR);
};
exports.useMlLocator = useMlLocator;
const useMlLink = (params, getUrlParams) => {
  const [href, setHref] = (0, _react.useState)(params.page);
  const mlLocator = useMlLocator();
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const generateUrl = async _params => {
      if (mlLocator) {
        const url = await mlLocator.getUrl(_params, getUrlParams);
        if (!isCancelled) {
          setHref(url);
        }
      }
    };
    generateUrl(params);
    return () => {
      isCancelled = true;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [params, getUrlParams]);
  return href;
};
exports.useMlLink = useMlLink;
const useCreateAndNavigateToMlLink = page => {
  const mlLocator = useMlLocator();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    services: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _kibana_context.useMlKibana)();
  const redirectToMlPage = (0, _react.useCallback)(async _page => {
    const pageState = (globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined ? {
      globalState: {
        refreshInterval: globalState.refreshInterval
      }
    } : undefined;

    // TODO: fix ts only interpreting it as MlUrlGenericState if pageState is passed
    // @ts-ignore
    const url = await mlLocator.getUrl({
      page: _page,
      pageState
    });
    await navigateToUrl(url);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mlLocator, navigateToUrl]);

  // returns the onClick callback
  return (0, _react.useCallback)(() => redirectToMlPage(page), [redirectToMlPage, page]);
};
exports.useCreateAndNavigateToMlLink = useCreateAndNavigateToMlLink;