"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VegaChartView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _vegaLite = require("vega-lite/build/vega-lite");
var _vega = require("vega");
var _vegaInterpreter = require("vega-interpreter");
var _vegaTooltip = require("vega-tooltip");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// There is still an issue with Vega Lite's typings with the strict mode Kibana is using.
// @ts-ignore

// There is still an issue with Vega Lite's typings with the strict mode Kibana is using.
// @ts-ignore

const VegaChartView = ({
  vegaSpec
}) => {
  const htmlId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  (0, _react.useEffect)(() => {
    const vgSpec = (0, _vegaLite.compile)(vegaSpec).spec;
    const view = new _vega.View((0, _vega.parse)(vgSpec, undefined, {
      ast: true
    }), {
      expr: _vegaInterpreter.expressionInterpreter
    }).logLevel(_vega.Warn).renderer('canvas').tooltip(new _vegaTooltip.Handler().call).initialize(`#${htmlId}`);
    view.runAsync(); // evaluate and render the view
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [vegaSpec]);
  return /*#__PURE__*/_react.default.createElement("div", {
    id: htmlId,
    className: "mlVegaChart",
    "data-test-subj": "mlVegaChart"
  });
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.VegaChartView = VegaChartView;
var _default = VegaChartView;
exports.default = _default;