"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionsSection = ConditionsSection;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _condition_expression = require("./condition_expression");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering the form fields for editing the conditions section of a rule.
 */

function ConditionsSection({
  isEnabled,
  conditions,
  addCondition,
  updateCondition,
  deleteCondition
}) {
  if (isEnabled === false) {
    return null;
  }
  let expressions = [];
  if (conditions !== undefined) {
    expressions = conditions.map((condition, index) => {
      return /*#__PURE__*/_react.default.createElement(_condition_expression.ConditionExpression, {
        key: index,
        index: index,
        appliesTo: condition.applies_to,
        operator: condition.operator,
        value: condition.value,
        updateCondition: updateCondition,
        deleteCondition: deleteCondition
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expressions, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => addCondition()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.conditionsSection.addNewConditionButtonLabel",
    defaultMessage: "Add new condition"
  })));
}
ConditionsSection.propTypes = {
  isEnabled: _propTypes.default.bool.isRequired,
  conditions: _propTypes.default.array,
  addCondition: _propTypes.default.func.isRequired,
  updateCondition: _propTypes.default.func.isRequired,
  deleteCondition: _propTypes.default.func.isRequired
};