"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsSection = ActionsSection;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering the form fields for editing the actions section of a rule.
 */

function ActionsSection({
  actions,
  onSkipResultChange,
  onSkipModelUpdateChange
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.actionsSection.chooseActionsDescription",
    defaultMessage: "Choose the actions to take when the job rule matches an anomaly."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "skip_result_cb",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.actionsSection.skipResultLabel",
      defaultMessage: "Skip result (recommended)"
    }),
    checked: actions.indexOf(_mlAnomalyUtils.ML_DETECTOR_RULE_ACTION.SKIP_RESULT) > -1,
    onChange: onSkipResultChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.actionsSection.resultWillNotBeCreatedTooltip",
      defaultMessage: "The result will not be created."
    }),
    size: "s",
    position: "right"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "skip_model_update_cb",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.actionsSection.skipModelUpdateLabel",
      defaultMessage: "Skip model update"
    }),
    checked: actions.indexOf(_mlAnomalyUtils.ML_DETECTOR_RULE_ACTION.SKIP_MODEL_UPDATE) > -1,
    onChange: onSkipModelUpdateChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.actionsSection.valueWillNotBeUsedToUpdateModelTooltip",
      defaultMessage: "The value for that series will not be used to update the model."
    }),
    size: "s",
    position: "right"
  }))));
}
ActionsSection.propTypes = {
  actions: _propTypes.default.array.isRequired,
  onSkipResultChange: _propTypes.default.func.isRequired,
  onSkipModelUpdateChange: _propTypes.default.func.isRequired
};