"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewAndCreatePipeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../contexts/kibana");
var _reindex_with_pipeline = require("./reindex_with_pipeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MANAGEMENT_APP_ID = 'management';
const ReviewAndCreatePipeline = ({
  inferencePipeline,
  modelType,
  pipelineName,
  pipelineCreated,
  pipelineError,
  sourceIndex
}) => {
  var _application$capabili, _application$capabili2;
  const {
    services: {
      application,
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [isNextStepsAccordionOpen, setIsNextStepsAccordionOpen] = (0, _react.useState)('closed');
  const inferenceProcessorLink = modelType === 'regression' ? links.ingest.inferenceRegression : links.ingest.inferenceClassification;
  const accordionId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const configCodeBlock = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: "400px",
    "data-test-subj": "mlTrainedModelsInferenceReviewAndCreateStepConfigBlock"
  }, JSON.stringify(inferencePipeline !== null && inferencePipeline !== void 0 ? inferencePipeline : {}, null, 2)), [inferencePipeline]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "mlTrainedModelsInferenceReviewAndCreateStep"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, pipelineCreated === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.title', {
    defaultMessage: "Review the pipeline configuration for '{pipelineName}'",
    values: {
      pipelineName
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), pipelineCreated === true && pipelineError === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "mlTrainedModelsInferenceReviewAndCreateStepSuccessCallout",
    title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.successMessage', {
      defaultMessage: "'{pipelineName}' has been created successfully.",
      values: {
        pipelineName
      }
    }),
    color: "success",
    iconType: "check"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.reIndexingMessage",
    defaultMessage: "You can use this pipeline to infer against new data or infer against existing data by {reindexLink} with the pipeline.",
    values: {
      reindexLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => setIsNextStepsAccordionOpen('open')
      }, 'reindexing')
    }
  }), (_application$capabili = application.capabilities.management) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.ingest) !== null && _application$capabili2 !== void 0 && _application$capabili2.ingest_pipelines ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.ingestPipelinesManagementMessage",
    defaultMessage: " Navigate to {pipelineManagementLink} to view and manage pipelines.",
    values: {
      pipelineManagementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: async () => {
          await application.navigateToApp(MANAGEMENT_APP_ID, {
            path: `/ingest/ingest_pipelines/?pipeline=${pipelineName}`,
            openInNewTab: true
          });
        },
        target: "_blank",
        external: true
      }, 'Ingest Pipelines')
    }
  }) : null)) : null, pipelineError !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.failureMessage', {
      defaultMessage: "Unable to create '{pipelineName}'.",
      values: {
        pipelineName
      }
    }),
    color: "danger",
    iconType: "error"
  }, /*#__PURE__*/_react.default.createElement("p", null, pipelineError), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.create.docLinkInErrorMessage",
    defaultMessage: "Learn more about {ingestPipelineConfigLink} and {inferencePipelineConfigLink} configuration.",
    values: {
      ingestPipelineConfigLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: links.ingest.pipelines,
        external: true,
        target: '_blank'
      }, 'ingest pipeline'),
      inferencePipelineConfigLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: modelType ? inferenceProcessorLink : links.ingest.inference,
        external: true,
        target: '_blank'
      }, 'inference processor')
    }
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, !pipelineCreated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.description",
    defaultMessage: "This pipeline will be created with the configuration below."
  }) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, pipelineCreated && sourceIndex ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.nextStepsLabel",
      defaultMessage: "Next steps"
    }),
    forceState: isNextStepsAccordionOpen,
    onToggle: isOpen => {
      setIsNextStepsAccordionOpen(isOpen ? 'open' : 'closed');
    }
  }, /*#__PURE__*/_react.default.createElement(_reindex_with_pipeline.ReindexWithPipeline, {
    pipelineName: pipelineName,
    sourceIndex: sourceIndex
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, pipelineCreated ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.review.viewConfig",
      defaultMessage: "View configuration"
    })
  }, configCodeBlock)) : [configCodeBlock])));
};
exports.ReviewAndCreatePipeline = ReviewAndCreatePipeline;