"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _get_steps = require("../get_steps");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddInferencePipelineFooter = ({
  isDetailsStepValid,
  isConfigureProcessorStepValid,
  creatingPipeline,
  pipelineCreated,
  onClose,
  onCreate,
  step,
  setStep
}) => {
  const {
    nextStep,
    previousStep,
    isContinueButtonEnabled
  } = (0, _react.useMemo)(() => (0, _get_steps.getSteps)(step, isDetailsStepValid, isConfigureProcessorStepValid), [isDetailsStepValid, isConfigureProcessorStepValid, step]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "mlTrainedModelsInferencePipelineCloseButton"
  }, pipelineCreated ? _constants.CLOSE_BUTTON_LABEL : _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, previousStep !== undefined && pipelineCreated === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    iconType: "arrowLeft",
    onClick: () => setStep(previousStep)
  }, _constants.BACK_BUTTON_LABEL) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, nextStep !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlTrainedModelsInferencePipelineContinueButton",
    iconType: "arrowRight",
    iconSide: "right",
    onClick: () => setStep(nextStep),
    disabled: !isContinueButtonEnabled,
    fill: true
  }, _constants.CONTINUE_BUTTON_LABEL) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlTrainedModelsInferencePipelineCreateButton",
    color: "success",
    disabled: !isContinueButtonEnabled || creatingPipeline || pipelineCreated,
    fill: true,
    onClick: onCreate,
    isLoading: creatingPipeline
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.addInferencePipelineModal.footer.create', {
    defaultMessage: 'Create pipeline'
  }))));
};
exports.AddInferencePipelineFooter = AddInferencePipelineFooter;