"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewSelectionIdBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _job_selector_badge = require("../job_selector_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewSelectionIdBadges = ({
  limit,
  maps,
  newSelection,
  onDeleteClick,
  onLinkClick,
  showAllBadges
}) => {
  const badges = [];
  for (let i = 0; i < newSelection.length; i++) {
    if (i >= limit && showAllBadges === false) {
      break;
    }
    badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: newSelection[i]
    }, /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
      id: newSelection[i],
      icon: true,
      isGroup: maps.groupsMap[newSelection[i]] !== undefined,
      removeId: onDeleteClick
    })));
  }
  if (showAllBadges === false && newSelection.length > limit) {
    badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: "more-badges-link",
      onClick: onLinkClick
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, _i18n.i18n.translate('xpack.ml.jobSelector.showFlyoutBadges', {
      defaultMessage: `And {overFlow} more`,
      values: {
        overFlow: newSelection.length - limit
      }
    }))));
  } else if (showAllBadges === true && newSelection.length > limit) {
    badges.push( /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: "hide-badges-link",
      onClick: onLinkClick
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs"
    }, _i18n.i18n.translate('xpack.ml.jobSelector.hideFlyoutBadges', {
      defaultMessage: 'Hide'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badges);
};
exports.NewSelectionIdBadges = NewSelectionIdBadges;