"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_field_stats_flytout_context = require("./use_field_stats_flytout_context");
var _field_stats_content = require("./field_stats_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldStatsFlyout = ({
  dataView,
  fieldStatsServices,
  timeRangeMs,
  dslQuery
}) => {
  const {
    setIsFlyoutVisible,
    isFlyoutVisible,
    fieldName
  } = (0, _use_field_stats_flytout_context.useFieldStatsFlyoutContext)();
  const closeFlyout = (0, _react.useCallback)(() => setIsFlyoutVisible(false), []); // eslint-disable-line react-hooks/exhaustive-deps
  const pushedFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'mlJobCreationWizardFieldStats'
  });
  if (isFlyoutVisible) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      type: "push",
      size: "xs",
      onClose: closeFlyout,
      "aria-labelledby": pushedFlyoutTitleId,
      "data-test-subj": "mlFieldStatsFlyout"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: pushedFlyoutTitleId
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.fieldContextFlyoutTitle",
      defaultMessage: "Field statistics"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      css: (0, _react2.css)`
            width: 300px;
          `
    }, /*#__PURE__*/_react.default.createElement("b", null, fieldName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_field_stats_content.FieldStatsContent, {
      dataView: dataView,
      fieldStatsServices: fieldStatsServices,
      timeRangeMs: timeRangeMs,
      dslQuery: dslQuery
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: closeFlyout
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.fieldContextFlyoutCloseButton",
      defaultMessage: "Close"
    }))));
  }
  return null;
};
exports.FieldStatsFlyout = FieldStatsFlyout;