"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertEntryFormatter = getAlertEntryFormatter;
exports.getAlertFormatters = getAlertFormatters;
exports.getRenderCellValue = exports.getMappedNonEcsValue = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/field-formats-plugin/common");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _eui = require("@elastic/eui");
var _alerts = require("../../../common/constants/alerts");
var _use_field_formatter = require("../../application/contexts/kibana/use_field_formatter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMappedNonEcsValue = ({
  data,
  fieldName
}) => {
  const item = data.find(d => d.field === fieldName);
  if (item != null && item.value != null) {
    return item.value;
  }
  return undefined;
};
exports.getMappedNonEcsValue = getMappedNonEcsValue;
const getRenderValue = mappedNonEcsValue => {
  // can be updated when working on https://github.com/elastic/kibana/issues/140819
  const value = Array.isArray(mappedNonEcsValue) ? mappedNonEcsValue.join() : mappedNonEcsValue;
  if (!(0, _lodash.isEmpty)(value)) {
    if (typeof value === 'object') {
      return JSON.stringify(value);
    }
    return value;
  }
  return '—';
};
const getRenderCellValue = fieldFormats => {
  const alertValueFormatter = getAlertFormatters(fieldFormats);
  return ({
    setFlyoutAlert
  }) => props => {
    const {
      columnId,
      data
    } = props;
    if (!(0, _mlIsDefined.isDefined)(data)) return;
    const mappedNonEcsValue = getMappedNonEcsValue({
      data,
      fieldName: columnId
    });
    const value = getRenderValue(mappedNonEcsValue);
    return alertValueFormatter(columnId, value);
  };
};
exports.getRenderCellValue = getRenderCellValue;
function getAlertFormatters(fieldFormats) {
  const getFormatter = (0, _use_field_formatter.getFieldFormatterProvider)(fieldFormats);
  return (columnId, value) => {
    switch (columnId) {
      case _ruleDataUtils.ALERT_START:
      case _ruleDataUtils.ALERT_END:
      case _alerts.ALERT_ANOMALY_TIMESTAMP:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getFormatter(_common.FIELD_FORMAT_IDS.DATE)(value));
      case _ruleDataUtils.ALERT_DURATION:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getFormatter(_common.FIELD_FORMAT_IDS.DURATION, {
          inputFormat: 'microseconds',
          outputFormat: 'humanizePrecise'
        })(value));
      case _alerts.ALERT_ANOMALY_SCORE:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          textSize: 'xs',
          color: (0, _mlAnomalyUtils.getSeverityColor)(value)
        }, getFormatter(_common.FIELD_FORMAT_IDS.NUMBER)(value));
      default:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
    }
  };
}
function getAlertEntryFormatter(fieldFormats) {
  const alertValueFormatter = getAlertFormatters(fieldFormats);
  return (columnId, value) => {
    return {
      title: _alerts.alertFieldNameMap[columnId],
      description: alertValueFormatter(columnId, value)
    };
  };
}