"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_ALERTS_CONFIG_ID = void 0;
exports.registerAlertsTableConfiguration = registerAlertsTableConfiguration;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_alerts_flyout = require("./use_alerts_flyout");
var _alerts = require("../../../common/constants/alerts");
var _render_cell_value = require("./render_cell_value");
var _alert_actions = require("./alert_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerAlertsTableConfiguration(triggersActionsUi, fieldFormats) {
  const columns = [{
    id: _ruleDataUtils.ALERT_STATUS,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.status', {
      defaultMessage: 'Status'
    }),
    initialWidth: 150
  }, {
    id: _ruleDataUtils.ALERT_REASON,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.reason', {
      defaultMessage: 'Reason'
    }),
    initialWidth: 150
  }, {
    id: _ruleDataUtils.ALERT_RULE_NAME,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.ruleName', {
      defaultMessage: 'Rule name'
    }),
    initialWidth: 150
  }, {
    id: _alerts.ALERT_ANOMALY_DETECTION_JOB_ID,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.jobId', {
      defaultMessage: 'Job ID'
    }),
    initialWidth: 150
  }, {
    id: _alerts.ALERT_ANOMALY_SCORE,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.anomalyScore', {
      defaultMessage: 'Latest anomaly score'
    }),
    initialWidth: 150,
    isSortable: true,
    schema: 'numeric'
  }, {
    id: _ruleDataUtils.ALERT_START,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.triggeredAt', {
      defaultMessage: 'Triggered at'
    }),
    initialWidth: 250,
    schema: 'datetime'
  }, {
    id: _ruleDataUtils.ALERT_END,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.recoveredAt', {
      defaultMessage: 'Recovered at'
    }),
    initialWidth: 250,
    schema: 'datetime'
  }, {
    id: _alerts.ALERT_ANOMALY_TIMESTAMP,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.anomalyTime', {
      defaultMessage: 'Latest anomaly time'
    }),
    initialWidth: 250,
    schema: 'datetime'
  }, {
    id: _ruleDataUtils.ALERT_DURATION,
    displayAsText: _i18n.i18n.translate('xpack.ml.alertsTable.columns.duration', {
      defaultMessage: 'Duration'
    }),
    initialWidth: 150,
    schema: 'numeric'
  }];
  const sort = [{
    [_ruleDataUtils.ALERT_START]: {
      order: 'desc'
    }
  }];
  const config = {
    id: ML_ALERTS_CONFIG_ID,
    columns,
    useInternalFlyout: (0, _use_alerts_flyout.getAlertFlyout)(columns, (0, _render_cell_value.getAlertFormatters)(fieldFormats)),
    getRenderCellValue: (0, _render_cell_value.getRenderCellValue)(fieldFormats),
    sort,
    useActionsColumn: () => ({
      renderCustomActionsRow: props => {
        return /*#__PURE__*/_react.default.createElement(_alert_actions.AlertActions, props);
      }
    })
  };
  triggersActionsUi.alertsTableConfigurationRegistry.register(config);
}
const ML_ALERTS_CONFIG_ID = 'mlAlerts';
exports.ML_ALERTS_CONFIG_ID = ML_ALERTS_CONFIG_ID;