"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBoomError = isBoomError;
exports.isErrorMessage = isErrorMessage;
exports.isErrorString = isErrorString;
exports.isEsErrorBody = isEsErrorBody;
exports.isMLResponseError = isMLResponseError;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Short hand type of estypes.ErrorCause.
 * @typedef {EsErrorRootCause}
 */

/**
 * Short hand type of estypes.ErrorResponseBase.
 * @typedef {EsErrorBody}
 */

/**
 * ML Response error
 * @export
 * @interface MLResponseError
 * @typedef {MLResponseError}
 */

/**
 * Interface holding error message
 * @export
 * @interface ErrorMessage
 * @typedef {ErrorMessage}
 */

/**
 * To be used for client side errors related to search query bars.
 */

/**
 * ML Error Object
 * @export
 * @interface MLErrorObject
 * @typedef {MLErrorObject}
 */

/**
 * MLHttpFetchErrorBase
 * @export
 * @interface MLHttpFetchErrorBase
 * @typedef {MLHttpFetchErrorBase}
 * @template T
 * @extends {IHttpFetchError<T>}
 */

/**
 * MLHttpFetchError
 * @export
 * @typedef {MLHttpFetchError}
 */

/**
 * Union type of error types
 * @export
 * @typedef {ErrorType}
 */

/**
 * Type guard to check if error is of type EsErrorBody
 * @export
 * @param {any} error
 * @returns {error is EsErrorBody}
 */
function isEsErrorBody(error) {
  var _error$error;
  return error && ((_error$error = error.error) === null || _error$error === void 0 ? void 0 : _error$error.reason) !== undefined;
}

/**
 * Type guard to check if error is a string.
 * @export
 * @param {any} error
 * @returns {error is string}
 */
function isErrorString(error) {
  return typeof error === 'string';
}

/**
 * Type guard to check if error is of type ErrorMessage.
 * @export
 * @param {any} error
 * @returns {error is ErrorMessage}
 */
function isErrorMessage(error) {
  return error && error.message !== undefined && typeof error.message === 'string';
}

/**
 * Type guard to check if error is of type MLResponseError.
 * @export
 * @param {any} error
 * @returns {error is MLResponseError}
 */
function isMLResponseError(error) {
  return typeof error.body === 'object' && 'message' in error.body;
}

/**
 * Type guard to check if error is of type Boom.
 * @export
 * @param {any} error
 * @returns {error is Boom.Boom}
 */
function isBoomError(error) {
  return (error === null || error === void 0 ? void 0 : error.isBoom) === true;
}