"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIGNIFICANT_ITEM_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Represents a field-based cardinality aggregation configuration.
 * @interface
 */

/**
 * Represents a script-based cardinality aggregation configuration.
 * @interface
 */

/**
 * Interface for cardinality aggregation.
 * @interface
 */

/**
 * Field/value pair definition.
 */

/**
 * Interface describing attributes used for numeric histograms.
 * @interface
 */

/**
 * Record/Map of histogram attributes where the key is the aggregation name.
 */

/**
 * Represents parameters used to identify which histogram data needs to be generated for a field.
 * @interface
 */

/**
 * Enumeration of significant item types.
 */
const SIGNIFICANT_ITEM_TYPE = {
  KEYWORD: 'keyword',
  LOG_PATTERN: 'log_pattern'
};

/**
 * Type for significant item type keys.
 */

/**
 * Represents the type of significant item as determined by the SIGNIFICANT_ITEM_TYPE enumeration.
 */

/**
 * Represents significant item metadata for a field/value pair.
 * This interface is used as a custom type within Log Rate Analysis
 * for a p-value based variant, not related to the generic
 * significant terms aggregation type.
 *
 * @interface
 * @extends FieldValuePair
 */

/**
 * @deprecated since version 2 of internal log rate analysis REST API endpoint
 */

/**
 * Represents a data item in a significant term histogram.
 */

/**
 * Represents histogram data for a field/value pair.
 * @interface
 */

/**
 * Represents histogram data for a group of field/value pairs.
 * @interface
 */

/**
 * Represents an item in a significant item group.
 * @interface
 */

/**
 * Represents a significant item group.
 * @interface
 */
exports.SIGNIFICANT_ITEM_TYPE = SIGNIFICANT_ITEM_TYPE;