"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tsvb = void 0;
var _host_system_overview = require("./host_system_overview");
var _host_cpu_usage = require("./host_cpu_usage");
var _host_load = require("./host_load");
var _host_memory_usage = require("./host_memory_usage");
var _host_network_traffic = require("./host_network_traffic");
var _host_filesystem = require("./host_filesystem");
var _host_k8s_overview = require("./host_k8s_overview");
var _host_k8s_cpu_cap = require("./host_k8s_cpu_cap");
var _host_k8s_pod_cap = require("./host_k8s_pod_cap");
var _host_k8s_disk_cap = require("./host_k8s_disk_cap");
var _host_k8s_memory_cap = require("./host_k8s_memory_cap");
var _host_docker_top_5_by_memory = require("./host_docker_top_5_by_memory");
var _host_docker_top_5_by_cpu = require("./host_docker_top_5_by_cpu");
var _host_docker_overview = require("./host_docker_overview");
var _host_docker_info = require("./host_docker_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tsvb = {
  hostSystemOverview: _host_system_overview.hostSystemOverview,
  hostCpuUsage: _host_cpu_usage.hostCpuUsage,
  hostLoad: _host_load.hostLoad,
  hostMemoryUsage: _host_memory_usage.hostMemoryUsage,
  hostNetworkTraffic: _host_network_traffic.hostNetworkTraffic,
  hostFilesystem: _host_filesystem.hostFilesystem,
  hostK8sOverview: _host_k8s_overview.hostK8sOverview,
  hostK8sCpuCap: _host_k8s_cpu_cap.hostK8sCpuCap,
  hostK8sPodCap: _host_k8s_pod_cap.hostK8sPodCap,
  hostK8sDiskCap: _host_k8s_disk_cap.hostK8sDiskCap,
  hostK8sMemoryCap: _host_k8s_memory_cap.hostK8sMemoryCap,
  hostDockerOverview: _host_docker_overview.hostDockerOverview,
  hostDockerInfo: _host_docker_info.hostDockerInfo,
  hostDockerTop5ByMemory: _host_docker_top_5_by_memory.hostDockerTop5ByMemory,
  hostDockerTop5ByCpu: _host_docker_top_5_by_cpu.hostDockerTop5ByCpu
};
exports.tsvb = tsvb;