"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rx = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rx = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.rx', {
    defaultMessage: 'Network Inbound (RX)'
  }),
  value: "average(host.network.ingress.bytes) * 8 / (max(metricset.period, kql='host.network.ingress.bytes: *') / 1000)",
  format: {
    id: 'bits',
    params: {
      decimals: 1
    }
  },
  timeScale: 's'
};
exports.rx = rx;