"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.memoryUsage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const memoryUsage = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.memoryUsage', {
    defaultMessage: 'Memory Usage'
  }),
  value: 'average(system.memory.actual.used.pct)',
  format: {
    id: 'percent',
    params: {
      decimals: 0
    }
  }
};
exports.memoryUsage = memoryUsage;